package com.link.bi.controller.query;

import com.link.bi.pojo.request.EcStoreVo;
import com.link.bi.service.IEcGoodsSupplyDemandService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 电商-货物供需Controller
 *
 * @author admin
 * @date 2024-12-05
 */
@RestController
@RequestMapping("/demand/core")
public class EcGoodsSupplyDemandQueryController extends BaseController
{
    @Autowired
    private IEcGoodsSupplyDemandService ecGoodsSupplyDemandService;

    /**
     * 导出电商-货物供需列表
     */
    @RequiresPermissions("bi:demand:list")
    @GetMapping("/list")
    public PageInfo list(EcStoreVo ecStoreVo)
    {
        return ecGoodsSupplyDemandService.selectPage(ecStoreVo);
    }

}
