package com.link.bi.service;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.link.bi.domain.entity.FinanceBaseProduct;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.response.FinanceBaseProductListDto;

import java.util.List;
import java.util.Map;


public interface FinanceBaseProductService extends IService<FinanceBaseProduct> {
    Map<String,FinanceBaseProduct> selectBaseProduct();


    boolean saveProduct(FinanceBaseProduct product);
    boolean removeProductById(Integer id);
    boolean updateProduct(FinanceBaseProduct product);
    FinanceBaseProduct getProductById(Integer id);
    IPage<FinanceBaseProduct> pageProduct(IPage<FinanceBaseProduct> page, Wrapper<FinanceBaseProduct> wrapper);

    List<FinanceBaseProductListDto> flavorList(FinanceSelectCommonVo commonVo);

    List<FinanceBaseProductListDto> specList(FinanceSelectCommonVo commonVo);

    List<FinanceBaseProductListDto> productNameList(FinanceSelectCommonVo commonVo);


    List<FinanceBaseProductListDto> seriesList(FinanceSelectCommonVo commonVo);
}
