package com.link.bi.controller.query;

import com.link.bi.pojo.request.MarketSummaryVo;
import com.link.bi.service.ISummaryMarketDailyDetailService;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-11-21 17
 * @describe : 根据每日销售明细表进行汇总数据
 */
@RestController
@RequestMapping("/market/detail")
public class SummaryMarketDailyDetailController {

    @Autowired
    ISummaryMarketDailyDetailService summaryService;

    /**
     * 汇总到日期维度
     */
    @RequiresPermissions("bi:store:list")
    @GetMapping("/sum_d")
    public Map marketSummary(MarketSummaryVo summaryVo){
        summaryVo.setDate();
        summaryVo.checkPrdCodes();
        return summaryService.marketSummary(summaryVo);
    }

}
