package com.link.bi.controller.query;

import com.github.pagehelper.PageInfo;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.request.FinanceCostVo;
import com.link.bi.pojo.response.FinanceBaseProductListDto;
import com.link.bi.pojo.response.FinanceZbjTypeListDto;
import com.link.bi.service.FinanceBaseProductService;
import com.link.bi.service.FinanceBaseZbjTypeService;
import com.link.bi.service.FinanceOrderDetailService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 财务bi分析
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/finance")
public class FinanceOrderQueryController extends BaseController {
    @Autowired
    private FinanceOrderDetailService detailService;
    @Autowired
    private FinanceBaseZbjTypeService baseZbjTypeService;
    @Autowired
    private FinanceBaseProductService baseProductService;

    /**
     * 财务成本聚合列表
     */
    @RequiresPermissions("bi:finance:list")
    @PostMapping("/cost/list")
    public PageInfo selectBiFinanceCostList(@RequestBody  FinanceCostVo financeCostVo) {
        return detailService.selectBiFinanceCostList(financeCostVo);
    }


    /**
     * 财务成本聚合详情查询
     */
    @RequiresPermissions("bi:finance:list")
    @PostMapping("/cost/detail/list")
    public PageInfo selectBiFinanceCostDetailList(@RequestBody FinanceCostVo financeCostVo) {
        return detailService.selectBiFinanceCostDetailList(financeCostVo);
    }

    // 直播间类型下拉
    @RequiresPermissions("bi:finance:list")
    @GetMapping("/zbjType/list")
    public List<FinanceZbjTypeListDto> baseZbjTypeList(FinanceSelectCommonVo commonVo) {
        return baseZbjTypeService.baseZbjTypeList(commonVo);
    }
    // 口味
    @RequiresPermissions("bi:finance:list")
    @GetMapping("/flavor/list")
    public List<FinanceBaseProductListDto> flavorList(FinanceSelectCommonVo commonVo) {
        return baseProductService.flavorList(commonVo);
    }
    // 规格
    @RequiresPermissions("bi:finance:list")
    @GetMapping("/spec/list")
    public List<FinanceBaseProductListDto> specList(FinanceSelectCommonVo commonVo) {
        return baseProductService.specList(commonVo);
    }
    // 系列
    @RequiresPermissions("bi:finance:list")
    @GetMapping("/serieses/list")
    public List<FinanceBaseProductListDto> seriesList(FinanceSelectCommonVo commonVo) {
        return baseProductService.seriesList(commonVo);
    }
    // 商品名称
    @RequiresPermissions("bi:finance:list")
    @GetMapping("/productName/list")
    public List<FinanceBaseProductListDto> productNameList(FinanceSelectCommonVo commonVo) {
        return baseProductService.productNameList(commonVo);
    }

}
