package com.link.bi.pojo.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author : liqiulin
 * @date : 2024-11-20 16
 * @describe :
 */
@Data
public class EcStoreVo {

    /**
     * 店铺id
     */
    private Integer storeId;

    /**
     * 旺店通店铺编码
     */
    @NotBlank(message = "旺店通-店铺编码不可为空")
    private String storeCode;

    /**
     * 店铺名称
     */
    @NotBlank(message = "店铺名称不可为空")
    private String storeName;

    /**
     * 渠道
     */
    @NotNull(message = "请填写渠道")
    private Integer channelId;

    /**
     * 1 电商; 2 线下;
     */
    private String channel;

    /**
     * 平台
     */
    @NotNull(message = "请填写平台")
    private Integer platformId;

    /**
     * 1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他;
     */
    private String platform;

    /**
     * 0正常(默认),1停用
     */
    private Integer status;
}
