package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.bi.domain.dao.CollectOrderLogInfoDao;
import com.link.bi.domain.entity.CollectOrderLogInfo;
import com.link.bi.domain.mapper.CollectOrderLogInfoMapper;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public class CollectOrderLogInfoDaoImpl implements CollectOrderLogInfoDao {

    @Autowired
    private CollectOrderLogInfoMapper logInfoMapper;

    @Override
    public void insert(CollectOrderLogInfo collectOrderLogInfo) {
        logInfoMapper.insert(collectOrderLogInfo);
    }

    @Override
    public Date selectOrderLatest(Integer syncType) {
        // 查询最新发货日期
        List<CollectOrderLogInfo> orderList = logInfoMapper.selectList(
                new LambdaQueryWrapper<CollectOrderLogInfo>()
                        // 默认查询xxljob自动同步时间
                        .eq(CollectOrderLogInfo::getSyncType,syncType)
                        .eq(CollectOrderLogInfo::getDelFlag,0)
                        .orderByDesc(CollectOrderLogInfo::getUpdateTime)
                        .last("LIMIT 1"));
        if(ObjectUtils.isNotEmpty(orderList)){
            // 最新的数据日期
            return orderList.get(0).getLatestTime();
        }
        return null;
    }


}
