package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.dao.IProductDao;
import com.link.bi.domain.entity.ProInfo;
import com.link.bi.domain.mapper.ProInfoMapper;
import com.link.bi.domain.mapper.ProSeriesMapper;
import com.link.bi.domain.wq.ProductWq;
import com.sfa.common.core.enums.StatusType;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@Service
public class ProductDaoImpl implements IProductDao {
    @Autowired
    ProInfoMapper proInfoMapper;
    @Autowired
    ProSeriesMapper proSeriesMapper;

    @Override
    public List selectSeriesList() {
        List<Map<String, Object>> maps = proSeriesMapper.selectListByStatus(StatusType.VALID.getType());
        return maps;
    }

    @Override
    public PageInfo productPage(ProductWq pqw) {
        LambdaQueryWrapper<ProInfo> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(pqw.getSeriesId())){
            qw.eq(ProInfo::getSeriesId,pqw.getSeriesId());
        }
        if (StringUtils.isNotBlank(pqw.getPrdCode())){
            qw.eq(ProInfo::getPrdCode,pqw.getPrdCode());
        }
        if (StringUtils.isNotBlank(pqw.getPrdNameLike())){
            qw.like(ProInfo::getPrdName,pqw.getPrdNameLike());
        }

        Page<ProInfo> page = proInfoMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo<>(page);
    }
}
