package com.link.bi.pojo.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 采集订单日志信息
 *
 * @author lvbencai
 * @date a
 * @description
 */
@Data
public class CollectOrderLogListDto implements Serializable {

    /**
     * 唯一键，用于唯一标识采集订单日志信息记录
     */
    private Long cliId;

    /**
     * 采集订单的数量，存储为字符串，长度不超过 20 个字符
     */
    private Integer orderCount;

    /**
     * 采集订单的详细数量，存储为字符串，长度不超过 20 个字符
     */
    private Integer orderDetailCount;

    /**
     * 采集批次信息，可存储长度不超过 30 个字符，使用 utf8mb4 字符集和 utf8mb4_0900_ai_ci 校对规则
     */
    private String batchNo;

    /**
     * 采集的最新时间，代表上一次采集的结束时间，存储为日期时间类型
     */
    private Date latestTime;

    /**
     * 是否删除的标志，'0' 表示未删除，'1' 表示已删除，使用 utf8mb3 字符集和 utf8mb3_general_ci 校对规则
     */
    private String delFlag;

    /**
     * 创建者信息，存储为长度不超过 20 个字符的字符串
     */
    private String createBy;

    /**
     * 创建人的用户 ID，存储为长整型
     */
    private Long createUserId;

    /**
     * 创建时间，存储为日期时间类型，使用数据库的当前时间作为默认值
     */
    private Date createTime;

    /**
     * 更新者信息，存储为长度不超过 20 个字符的字符串
     */
    private String updateBy;

    /**
     * 修改人的用户 ID，存储为长整型
     */
    private Long updateUserId;

    /**
     * 更新时间，存储为日期时间类型，更新时自动更新为当前时间
     */
    private Date updateTime;
    private Integer syncType;


}
