package com.link.bi.domain.orderdomain.dao;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.orderdomain.entity.OrdersSent;
import com.link.bi.domain.orderdomain.mapper.OrdersSentMapper;
import com.link.bi.domain.orderdomain.wq.OrdersSentWq;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-08-14 17
 * @describe :
 */
@Service
public class OrdersSentDaoImpl implements IOrdersSentDao{

    @Autowired
    private OrdersSentMapper ordersSentMapper;

    @Override
    public PageInfo page(OrdersSentWq ordersSentWq) {
        LambdaQueryWrapper<OrdersSent> qw = builderWq(ordersSentWq);
        Page<OrdersSent> ordersSentPage = ordersSentMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo<OrdersSent> pageInfo = new PageInfo<>(ordersSentPage);
        return pageInfo;
    }

    @Override
    public void updateById(Long sendId, String receiptPhotoCompleteFlag, String sentStatus) {
        if (StringUtils.isAllBlank(receiptPhotoCompleteFlag,sentStatus)){
            throw new CheckedException(ECode.LEAST_INCLUDE_ONE_ERROR);
        }
        if (Objects.isNull(sendId)){
            throw new CheckedException(ECode.DB_TABLE_UNIQUE_EXIST, "发货单据");
        }
        ordersSentMapper.updateById(new OrdersSent().setSendId(sendId).setReceiptPhotoCompleteFlag(receiptPhotoCompleteFlag).setSentStatus(sentStatus));
    }


    private LambdaQueryWrapper<OrdersSent> builderWq(OrdersSentWq ordersSentWq) {
        LambdaQueryWrapper<OrdersSent> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(ordersSentWq.getAhSentNo())){
            qw.eq(OrdersSent::getAhSentNo, ordersSentWq.getAhSentNo());
        }
        if (StringUtils.isNotBlank(ordersSentWq.getBjSentNo())){
            qw.eq(OrdersSent::getBjSentNo, ordersSentWq.getBjSentNo());
        }
        if (StringUtils.isNotBlank(ordersSentWq.getTransport())){
            qw.eq(OrdersSent::getTransport, ordersSentWq.getTransport());
        }
        if (StringUtils.isNotBlank(ordersSentWq.getExpressNo())){
            qw.eq(OrdersSent::getExpressNo, ordersSentWq.getExpressNo());
        }
        if (StringUtils.isNotBlank(ordersSentWq.getDdNo())){
            qw.eq(OrdersSent::getDdNo, ordersSentWq.getDdNo());
        }
        if (ordersSentWq.getIsOperateEnd() != null && ordersSentWq.getIsOperateEnd()){
            qw.isNotNull(OrdersSent::getOperateEndDatetime);
        }
        if (ordersSentWq.getIsOperateEnd() != null && !ordersSentWq.getIsOperateEnd()){
            qw.isNull(OrdersSent::getOperateEndDatetime);
        }
        return qw;
    }
}
