package com.link.bi.domain.orderdomain.wq;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author : liqiulin
 * @date : 2025-08-14 18
 * @describe :
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class OrdersSentWq {


    /**
     * 安徽/北京单据编号
     */
    private String sentNo;

    /**
     * 安徽单据编号
     */
    private String ahSentNo;

    /**
     * 北京单据编号
     */
    private String bjSentNo;

    private String transport;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * DD单号
     */
    private String ddNo;

    /**
     * 是否签收
     */
    private Boolean isOperateEnd;

    public void setSentNo(String sentNo) {
        if (sentNo == null) {
            return;
        }
        if (sentNo.startsWith("BJHQ")){
            this.bjSentNo = sentNo;
        } else if (sentNo.startsWith("AHSD")) {
            this.ahSentNo = sentNo;
        }
    }
}
