package com.link.bi.controller.query;

import com.github.pagehelper.PageInfo;
import com.link.bi.pojo.request.FinanceCostVo;
import com.link.bi.service.FinanceOrderDetailService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 财务bi分析
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/finance")
public class FinanceOrderQueryController extends BaseController {
    @Autowired
    private FinanceOrderDetailService detailService;

    /**
     * 财务成本聚合查询
     */
    @RequiresPermissions("bi:finance:list")
    @PostMapping("/cost/list")
    public PageInfo selectBiFinanceCostList(@RequestBody  FinanceCostVo financeCostVo) {
        return detailService.selectBiFinanceCostList(financeCostVo);
    }


    /**
     * 财务成本聚合查询
     */
    @RequiresPermissions("bi:finance:list")
    @PostMapping("/cost/detail/list")
    public PageInfo selectBiFinanceCostDetailList(@RequestBody FinanceCostVo financeCostVo) {
        return detailService.selectBiFinanceCostDetailList(financeCostVo);
    }

}
