package com.link.bi.config.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.link.bi.pojo.response.FinanceBaseZbjTypeImportDto;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * 直播间分类导入监听
 * @author lvbcai
 * @date 2025年01月07日10:04:25
 */
@Data
@Slf4j
public class FinanceBaseZbjTypeListener extends AnalysisEventListener<FinanceBaseZbjTypeImportDto> {

    // 存储解析后的数据
    private List<FinanceBaseZbjTypeImportDto> dataList = new ArrayList<>();

    @Override
    public void invoke(FinanceBaseZbjTypeImportDto data, AnalysisContext context) {
        // 每解析一行数据就会调用该方法
        dataList.add(data);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        // 解析完所有数据后调用该方法
    }

    public List<FinanceBaseZbjTypeImportDto> getDataList() {
        return dataList;
    }
}
