package com.link.bi.pojo.orderrequest;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author : liqiulin
 * @date : 2025-08-14 16
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class OrdersSentVo {

    private Long sendId;

    /**
     * 安徽/北京单据编号
     */
    private String sentNo;

    private String transport;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * DD单号
     */
    private String ddNo;

    /**
     * 是否签收
     */
    private Boolean isOperateEnd;

    /**
     * 物流状态：【整单签收；整单拒收；部分退回在途；部分退回已完结；整单退回在途；整单退回完结；发货在途；部分滞留；整单滞留】
     */
    private String sentStatus;

    /**
     * 回单状态：【完整，不完整】
     */
    private String receiptPhotoCompleteFlag;
}
