package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.bi.domain.dao.CollectOrderLogDao;
import com.link.bi.domain.entity.CollectOrderLog;
import com.link.bi.domain.mapper.CollectOrderLogMapper;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public class CollectOrderLogDaoImpl implements CollectOrderLogDao {

    @Autowired
    private CollectOrderLogMapper logInfoMapper;

    @Override
    public void insert(CollectOrderLog collectOrderLog) {
        logInfoMapper.insert(collectOrderLog);
    }

    @Override
    public Date selectOrderSyncLatest(Integer syncType) {
        // 查询最新发货日期
        List<CollectOrderLog> orderList = logInfoMapper.selectList(
                new LambdaQueryWrapper<CollectOrderLog>()
                        // 默认查询xxljob自动同步时间
                        .eq(CollectOrderLog::getSyncType,syncType)
                        .eq(CollectOrderLog::getDelFlag,0)
                        .orderByDesc(CollectOrderLog::getUpdateTime)
                        .last("LIMIT 1"));
        if(ObjectUtils.isNotEmpty(orderList)){
            // 最新的数据日期
            return orderList.get(0).getLatestTime();
        }
        return null;
    }

    @Override
    public List<CollectOrderLog> list(Wrapper<CollectOrderLog> queryWrapper) {
        return logInfoMapper.selectList(queryWrapper);
    }


}
