package com.link.bi.pojo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.Date;

/**
 * @author lvbencai
 * @date 2022/12/20 10:18
 */
@Data
public class OppoSycmStoreDto {
    // 日期
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date date;

    /**
     * 平台店铺
     */
    private String platformStore;

    /**
     * 支付买家数(范围-低)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long zfmjUnder;

    /**
     * 支付买家数(范围-高)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long zfmjPeak;

    /**
     * %交易增速(范围-低)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long jyzsUnder;

    /**
     * %交易增速(范围-高)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long jyzsPeak;

    /**
     * unique visitor(独立访客范围-低)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long uvUnder;

    /**
     * unique visitor(独立访客范围-高)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long uvPeak;

    /**
     * %流量增速(范围-低)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long llzsUnder;

    /**
     * %流量增速(范围-高)
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long llzsPeak;
}
