# 《分布式任务调度平台XXL-JOB》(V1.4.x用户手册)
## 一、简介

#### 1.1 概述
XXL-JOB是一个轻量级分布式任务调度框架，其核心设计目标是开发迅速、学习简单、轻量级、易扩展。现已开放源代码并接入多家公司线上产品线，开箱即用。

#### 1.2 特性
- 1、简单：支持通过Web页面对任务进行CRUD操作，操作简单，一分钟上手；
- 2、动态：支持动态修改任务状态、暂停/恢复任务，以及终止运行中任务，即时生效；
- 3、调度HA：“调度中心”基于集群Quartz实现，可保证调度中心HA；
- 4、任务HA：任务支持多地址配置，可保证任务执行HA；
- 5、任务Failover：多地址配置时，调度失败时将会平滑切换执行器进行Failover；
- 6、一致性：“调度中心”通过DB锁保证集群分布式调度的一致性；
- 7、自定义任务参数：支持在线配置调度任务入参，即时生效；
- 8、调度线程池：调度系统多线程触发调度运行，确保调度精确执行，不被堵塞；
- 9、执行日志：支持在线查看调度结果，并且查看完整的执行日志；
- 10、邮件报警：任务失败时支持邮件报警，支持配置多邮件地址群发报警邮件；
- 11、支持登录验证；
- 12、GLUE：提供Web IDE，支持在线开发任务逻辑代码，动态发布，实时编译生效，省略部署上线的过程。

#### 1.3 发展
于2015年中，我在github上创建XXL-JOB项目仓库并提交第一个commit，随之进行系统结构设计，UI选型，交互设计……

于2015-11月，XXL-JOB终于REALEASE了第一个大版本V1.0， 随后我将之发布到OSCHINA，XXL-JOB在OSCHINA上获得了@红薯的热门推荐，同期分别达到了OSCHINA的“热门动弹”排行第一和git.oschina的开源软件月热度排行第一，在此特别感谢红薯，感谢大家的关注和支持。

于2015-12月，我将XXL-JOB发表到我司内部知识库，并且得到内部同事认可。

于2016-01月我司展开XXL-JOB的内部接入和定制工作，在此感谢袁某和尹某两位同事的贡献，同时也感谢内部其他给与关注与支持的同事。

**我司大众点评目前已接入XXL-JOB，内部别名《Ferrari》（Ferrari基于XXL-JOB的V1.1版本定制而成，新接入应用推荐升级最新版本）**。据最新统计, 自2016-01-21接入至2016-07-20期间，该系统已调度72000余次，表现优异。新接入应用推荐使用最新版本，因为经过数个大版本的更新，系统的任务模型、UI交互模型以及底层调度通讯模型都有了较大的优化和提升，核心功能更加稳定高效。

至今，XXL-JOB已接入多家公司的线上产品线，接入场景如电商业务，O2O业务和大数据作业等，截止2016-07-19为止，XXL-JOB已接入的公司包括不限于：
    
	- 1、大众点评；
	- 2、山东学而网络科技有限公司；
	- 3、安徽慧通互联科技有限公司；
	- 4、人人聚财金服；
	- 5、上海棠棣信息科技股份有限公司
	- 6、运满满
	- 7、米其林(中国区)
	- 8、妈妈联盟
	- ……

欢迎大家的关注和使用，XXL-JOB也将拥抱变化，持续发展。

#### 1.4 下载
源码地址 (将会在两个git仓库同步发布最新代码)

- [github地址](https://github.com/xuxueli/xxl-job)
- [git.osc地址](http://git.oschina.net/xuxueli0323/xxl-job)
- [用户手册地址,见源码“/doc”目录下](https://github.com/xuxueli/xxl-job/tree/master/doc)

博客地址

- [oschina地址](http://my.oschina.net/xuxueli/blog/690978)
- [cnblogs地址](http://www.cnblogs.com/xuxueli/p/5021979.html)
- [csdn地址](http://blog.csdn.net/xuxueli0323/article/details/51674330)

技术交流群(仅作技术交流)：367260654    [![image](http://pub.idqqimg.com/wpa/images/group.png)](http://shang.qq.com/wpa/qunwpa?idkey=4686e3fe01118445c75673a66b4cc6b2c7ce0641528205b6f403c179062b0a52 )


Tips: 历史Release版本下载位置如下图所示,请自行前往进行选择和下载。
![输入图片说明](https://static.oschina.net/uploads/img/201607/23221244_nq9a.png "在这里输入图片标题")

#### 1.5 环境
- Maven3+
- Jdk1.7+
- Tomcat7+
- Mysql5.5+


## 二、快速入门

#### 2.1 初始化“调度数据库”
请下载项目源码并解压，获取 "调度数据库初始化SQL脚本"(脚本文件为: 源码解压根目录\xxl-job\db\tables_xxl_job.sql) 并执行即可。

正常情况下,应该生成如下图所示14张表;
![输入图片说明](https://static.oschina.net/uploads/img/201607/23221308_DDW8.png "在这里输入图片标题")

#### 2.2 编译源码
解压源码,按照maven格式将源码导入IDE, 使用maven进行编译即可，源码结构如下图所示：

![输入图片说明](https://static.oschina.net/uploads/img/201607/23222522_JGCc.png "在这里输入图片标题")

- xxl-job-admin：调度中心
- xxl-job-core：公共依赖
- xxl-job-executor-example：执行器（可直接使用该执行器，也可以将现有项目改造成执行器使用）

#### 2.3 配置部署“调度中心”
调度中心项目：xxl-job-admin

作用：统一管理任务调度平台上调度任务，负责触发调度执行。

- **A：配置调度中心JDBC链接**：请在下图所示位置配置jdbc链接地址，链接地址请保持和 2.1章节 所创建的调度数据库的地址一致。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23222438_wZv9.png "在这里输入图片标题")

- **B：配置报警邮箱和登陆账号**：请在下图所示位置，设置自己的报警邮件发送邮箱和登陆账号密码。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23223008_ArvZ.png "在这里输入图片标题")

- **C：配置“调度中心”任务执行结果回调端口**：由于“调度中心”和“执行器”部署在不同项目中，“执行器”会请求该端口回调通知任务执行结果。如下图所示，默认回调服务端口号为8888。（此端口除非与现有端口冲突，可自行修改，否则可忽视）

![输入图片说明](https://static.oschina.net/uploads/img/201607/23223301_I03k.png "在这里输入图片标题")

**部署项目**：如果已经正确进行上述配置，可将项目编译打war包并部署到tomcat中。

访问链接：http://localhost:8080/xxl-job-admin/ ，登陆界面如下图所示

![输入图片说明](https://static.oschina.net/uploads/img/201607/23223648_b8Dx.png "在这里输入图片标题")

至此“调度中心”项目已经部署成功。

#### 2.4 配置部署“执行器项目”
“执行器”项目：xxl-job-executor-example

作用：负责接收“调度中心”的调度并执行；

- **A：配置Jdbc链接**：请在下图所示位置配置jdbc链接地址，链接地址请保持和 2.1章节 所创建的调度数据库的地址一致。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23224042_MeRg.png "在这里输入图片标题")

- **B：配置“执行器”端口**：由于“调度中心”和“执行器”部署在不同项目，“调度中心”会请求该端口触发任务执行。端口如下图所示，默认的“执行器”端口是9999，如果与系统现有端口冲突可自行修改，如若不冲突，可忽略。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23224304_0jxT.png "在这里输入图片标题")

**部署项目**：如果已经正确进行上述配置，可将项目编译打war包并部署到tomcat中。

至此“执行器”项目已经部署结束。

#### 2.5 开发第一个任务“Hello World”
本示例为新建一个“GLUE模式任务”（“GLUE模式任务”的执行代码支持托管到调度中心在线维护，相比“Bean模式任务”需要在执行器项目开发部署上线，更加简便轻量）。更多有关任务的详细配置，请查看“章节三：任务详解”。

**前提：请确认“调度中心”和“执行器”项目已经成功部署并启动；**

- **步骤一（新建任务）**：登陆调度中心，点击下图所示“新建任务”按钮，新建示例任务。然后，参考下面截图中任务的参数配置，点击保存。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23224905_MkGD.png "在这里输入图片标题")

![输入图片说明](https://static.oschina.net/uploads/img/201607/23225207_GSeQ.png "在这里输入图片标题")

- **步骤二（GLUE任务开发）**：请点击下图中所示“GLUE入口按钮”，进入“GLUE编辑器开发界面”，见下图。GLUE任务默认已经初始化了示例任务代码，即打印Hello World。
（GLUE实际上是一段继承自IJobHandler的Java类代码，它在执行器项目中运行，可使用@Resource/@Autowire注入执行器里中的其他服务，详细介绍请查看第三章节）

![输入图片说明](https://static.oschina.net/uploads/img/201607/23225310_RYby.png "在这里输入图片标题")

![输入图片说明](https://static.oschina.net/uploads/img/201607/23225327_Y1cn.png "在这里输入图片标题")

- **步骤三（触发执行）**：点击下图所示“执行”按钮，可手动触发一次任务执行（通常情况下，通过配置Cron表达式进行任务调度出发）。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23225653_iY9K.png "在这里输入图片标题")

- **步骤四（查看日志）**：
点击图2.5F所示“日志”按钮，可前往任务日志界面查看任务日志。
在如图2.5G的任务日志界面中，可查看任务调度状态，执行器接收到调度请求后的执行状态。
同时，点击如图2.5G中的“执行日志”按钮，可以查看本此调度在执行器端的完整执行日志，完整执行日志如图2.5H。

![输入图片说明](https://static.oschina.net/uploads/img/201607/23225953_7ey7.png "在这里输入图片标题")
（图2.5F：“调度中心”管理管理界面，任务日志入口）

![输入图片说明](https://static.oschina.net/uploads/img/201607/23230953_BFVV.png "在这里输入图片标题")
（图2.5G：“调度中心”管理管理界面，任务日志入口）

![输入图片说明](https://static.oschina.net/uploads/img/201607/23230416_2cLu.png "在这里输入图片标题")
（图2.5H：“调度中心”管理管理界面，任务日志入口）

## 三、任务详解
#### 4.1 BEAN模式任务
Bean模式任务：任务逻辑以JobHandler的形式存在于“执行器”所在项目中，开发流程如下：

- **步骤一：开发JobHandler**：
    - 1. 新建一个继承com.xxl.job.core.handler.IJobHandler的Java类；
    - 2. 该类被Spring容器扫描为Bean实例，如加“@Service注解”；
    - 3. 添加 “@JobHander(value="自定义jobhandler名称")”注解，注解的value值为自定义的JobHandler名称，该名称对应的是调度中心新建任务的JobHandler属性的值。
    （可参考xxl-job-executor-example项目中的DemoJobHandler，见下图）

![输入图片说明](https://static.oschina.net/uploads/img/201607/23232347_oLlM.png "在这里输入图片标题")


