package com.wangxiaolu.export.util;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.util.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.net.ssl.HttpsURLConnection;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-07-29 14
 * @describe :
 */
@Slf4j
@Component
public class FeishuSheetUtils {

    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String SHEET_URL = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/";
    private static final String TENANT_ACCESS_TOKEN_URL = "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal";
    private static final String VALUES_APPEND = "/values_append";
    private static final String VALUES_IMAGE = "/values_image";
    private static final String VALUES = "/values";

    /**
     * 追加一条记录
     *
     * @return 修改的行号
     */
    public Integer appendValueToSheet(String range, List<Object> datas, String sheetToken,String autoToken) {
        // 组装参数
        Map<String, Map<String, Object>> bodyMap = new HashMap<>();
        Map<String, Object> valueRange = new HashMap<>();
        valueRange.put("range", range);
        valueRange.put("values", Arrays.asList(datas));
        bodyMap.put("valueRange", valueRange);
        String bodyJson = JSONObject.toJSONString(bodyMap);

        // body上传
        String result = HttpUtil.createPost(SHEET_URL + sheetToken + VALUES_APPEND)
                .auth("Bearer "+ autoToken).contentType(CONTENT_TYPE)
                .body(bodyJson)
                .execute().body();

        // 上传结果判断
        JSONObject resultJson = JSONObject.parseObject(result);
        int code = resultJson.getInteger("code");
        if (code != 0) {
            log.error("活动上报错误：==============\n{}", result);
            log.error("请求参数：==============\n{}", bodyJson);
            return -1;
        }

        // 此次上传数据范围
        String tableRange = resultJson.getJSONObject("data").getString("tableRange");
        return NumberUtils.matcherNum(tableRange.split(":")[1]);
    }


    public void updateData(String range, List<Object> datas, String sheetToken, String autoToken) {
        try {
            // 组装参数
            Map<String, Map<String, Object>> bodyMap = new HashMap<>();
            Map<String, Object> valueRange = new HashMap<>();
            valueRange.put("range", range);
            valueRange.put("values", Arrays.asList(datas));
            bodyMap.put("valueRange", valueRange);
            String bodyJson = JSONObject.toJSONString(bodyMap);

            String result = HttpUtil.createRequest(Method.PUT,SHEET_URL + sheetToken + VALUES)
                    .auth("Bearer " + autoToken).contentType(CONTENT_TYPE)
                    .body(bodyJson)
                    .execute().body();

            // 判断上传结果
            JSONObject resultJson = JSONObject.parseObject(result);
            int code = resultJson.getInteger("code");
            if (code != 0) {
                log.error("修改数据失败，修改表格位置：{}，报错详情：\n{}", range, result);
            }
        } catch (Exception e) {
            log.error("修改数据失败，修改表格位置：{}", range);
        }
    }

    public void valuesImageToSheet(String range, String imageUrl, String sheetToken,String autoToken) {
        if (StringUtils.isBlank(imageUrl) || !imageUrl.startsWith("https")) {
            return;
        }
        try {
            // 获取图片二进制流
            byte[] imageByte = imageToByte(imageUrl);

            // 组装参数
            Map<String, Object> bodyMap = new HashMap<>();
            bodyMap.put("range", range);
            bodyMap.put("image", imageByte);
            bodyMap.put("name", imageUrl);
            String bodyJson = JSONObject.toJSONString(bodyMap);

            // 上传boday
            String result = HttpUtil.createPost(SHEET_URL + sheetToken + VALUES_IMAGE)
                    .auth("Bearer "+ autoToken).contentType(CONTENT_TYPE)
                    .body(bodyJson)
                    .execute().body();

            // 判断上传结果
            JSONObject resultJson = JSONObject.parseObject(result);
            int code = resultJson.getInteger("code");
            if (code != 0) {
                log.error("图片{}上传错误，上传表格位置：{}，报错详情：\n{}",imageUrl, range, result);
            }
        } catch (Exception e) {
            log.error("图片转换/上传异常，上传表格位置：{}", range);
        }

    }

    public JSONObject getFeishuTenantToken(String appId,String appSecret) {
        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("app_id", appId);
        bodyMap.put("app_secret", appSecret);
        String bodyJson = JSONObject.toJSONString(bodyMap);

        String result = HttpUtil.createPost(TENANT_ACCESS_TOKEN_URL)
                .contentType(CONTENT_TYPE)
                .body(bodyJson)
                .execute().body();

        JSONObject resultJson = JSONObject.parseObject(result);
        int code = resultJson.getInteger("code");
        if (code != 0) {
            throw new RuntimeException("获取tenant_access_token错误");
        }
        return resultJson;
    }

    private byte[] imageToByte(String fileUrl) throws Exception {
        URL url = new URL(fileUrl);
        // 打开链接，并且跳过 SSL 证书验证
        HttpsUtils.trustAllHttpsCertificates();
        HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5 * 1000);
        // 通过输入流获取图片数据
        InputStream inStream = conn.getInputStream();
        // 得到文件的二进制数据，以二进制封装得到数据，具有通用性
        byte[] data = readInputStream(inStream);
        // 关闭流
        inStream.close();
        return data;
    }

    private byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        // 每次读取的字符串长度，如果为-1，代表全部读取完毕
        int len = 0;
        // 使用一个输入流从buffer里把数据读取出来
        while ((len = inStream.read(buffer)) != -1) {
            // 用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
            outStream.write(buffer, 0, len);
        }
        // 关闭输入流
        inStream.close();
        // 把outStream里的数据写入内存
        return outStream.toByteArray();
    }

}
