package com.wangxiaolu.export.controller.feishu;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.pojo.ActivityVo;
import com.wangxiaolu.export.service.ActivityToFeishuSheetService;
import com.wangxiaolu.export.service.PromotionActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-06-14 11
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/promotion/activity")
public class ActivityToFeishuSheet {

    @Autowired
    PromotionActivityService promotionActivityService;

    @Autowired
    ActivityToFeishuSheetService activityToFeishuSheetService;

    /**
     * 飞书电子表格
     * @param activityVo 查询活动创建日期范围
     */
    @PostMapping("/feishu/sheet")
    public void activityList(@RequestBody ActivityVo activityVo) {

        /**
         * 1>> 查询活动记录
         * 查询当天的记录
         */
        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityList(activityVo);
        List<Long> activityId = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());
        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityId);

        /**
         * 2>> 查询打卡记录
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhoto(activityVo);
        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });

        log.info("============== 活动记录上传飞书 start(" + System.currentTimeMillis() + ") ==============");

        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end(" + System.currentTimeMillis() + ") ==============");
    }

    @GetMapping("/feishu/yesterday_sheet")
    public void yesterdayActivityList(){
        log.info("============== 活动记录上传飞书 start ==============");
        /**
         * 1>> 查询前一天的活动记录
         */
        String yt = DateUtil.format(DateUtil.yesterday(), DatePattern.NORM_DATE_PATTERN);

        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityListByCreateDate(yt);

        if (CollectionUtils.isEmpty(reportedDos)){
            log.info("无活动记录，停止上传");
        }
        log.info("应上传飞书{}条活动记录",reportedDos.size());

        List<Long> activityId = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());
        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityId);

        /**
         * 2>> 查询打卡记录
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhotoByCreateDate(yt);
        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end ==============");
    }

}
