package com.wangxiaolu.export.service.impl;

import com.wangxiaolu.export.mapper.TemporaryActivityClockMapper;
import com.wangxiaolu.export.mapper.TemporaryActivityPhotoMapper;
import com.wangxiaolu.export.mapper.TemporaryActivityReportedMapper;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.pojo.ActivityVo;
import com.wangxiaolu.export.service.PromotionActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-06-14 15
 * @describe :
 */
@Service
public class PromotionActivityServiceImpl implements PromotionActivityService {

    @Autowired
    TemporaryActivityReportedMapper temporaryActivityReportedMapper;
    @Autowired
    TemporaryActivityClockMapper temporaryActivityClockMapper;
    @Autowired
    TemporaryActivityPhotoMapper temporaryActivityPhotoMapper;


    /**
     * 查询上报记录
     */
    @Override
    public List<TemporaryActivityReportedDO> findActivityList(ActivityVo activityVo) {
        List<TemporaryActivityReportedDO> dos = temporaryActivityReportedMapper.findList(activityVo);
        return dos;
    }

    /**
     * 查询打卡记录
     */
    @Override
    public List<TemporaryActivityClockDO> findClockPhoto(ActivityVo activityVo) {
        List<TemporaryActivityClockDO> clockPhotoList = temporaryActivityClockMapper.findClockPhotoList(activityVo);
        return clockPhotoList;
    }

    /**
     * 根据活动记录id、打卡记录id,查询所有图片
     */
    @Override
    public Map<Long, List<TemporaryActivityPhotoDO>> findActivityPhotos(List<Long> activityId) {
        List<TemporaryActivityPhotoDO> activityPhotoDOS = temporaryActivityPhotoMapper.findActivityPhotos(activityId);
        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotoMap = activityPhotoDOS.stream().collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getReportedId));
        return activityPhotoMap;
    }

}
