package com.wangxiaolu.export.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.export.mapper.FeishuSheetRecordMapper;
import com.wangxiaolu.export.mapper.entity.FeishuSheetRecordDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.service.ActivityToFeishuSheetService;
import com.wangxiaolu.export.util.FeishuSheetUtils;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-07-29 15
 * @describe :
 */
@Slf4j
@Service
public class ActivityToFeishuSheetServiceImpl implements ActivityToFeishuSheetService {

    private static FeishuSheetRecordDO sheetInfoD = null;

    @Value("${feishu.activity_robot_1.app_id}")
    private String appId1;
    @Value("${feishu.activity_robot_1.app_secret}")
    private String appSecret1;
    @Value("${feishu.activity_robot_2.app_id}")
    private String appId2;
    @Value("${feishu.activity_robot_2.app_secret}")
    private String appSecret2;

    @Autowired
    RedisCache redisCache;
    @Autowired
    FeishuSheetUtils feishuSheetUtils;
    @Autowired
    FeishuSheetRecordMapper feishuSheetRecordMapper;

    @Override
    public void activityDataToFeishuSheet(List<TemporaryActivityReportedDO> reportedDos, Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos, Map<Long, TemporaryActivityClockDO> clockMap, Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap) {
        sheetInfoD = null;
        // 查询要更新的电子表格、工作表，每天凌晨开始更新，所以获取前一天日期
        String month = DateUtil.format(DateUtil.yesterday(), "yyyy-MM");
        FeishuSheetRecordDO sheetInfo = feishuSheetRecordMapper.selectOneByCreateMonth(month);
        if (Objects.isNull(sheetInfo)) {
            log.error("电子文档token信息获取失败，取消上传");
            return;
        }
        sheetInfoD = sheetInfo;

        log.info("上传至电子文档中的活动记录共「{}」条", reportedDos.size());
        int index = 1;

        for (TemporaryActivityReportedDO rdo : reportedDos) {
            log.info("------- 上传标号{} start -------", index);
            try {
                // [temporaryId]-[createDate]： 做唯一key
                String clockKey = rdo.getTemporaryId() + "-" + rdo.getCreateDate();
                List<TemporaryActivityPhotoDO> temporaryActivityPhotoDOS = activityPhotos.get(rdo.getId());
                TemporaryActivityClockDO clockDo = clockMap.get(rdo.getId());
                List<TemporaryActivityPhotoDO> activityClock = clockPhotoMap.containsKey(clockKey) ? clockPhotoMap.get(clockKey) : new ArrayList<>();
                activityDataToSheetRow(rdo, temporaryActivityPhotoDOS, activityClock,clockDo);
            } catch (Exception e) {
                log.error(e.toString(),e);
                log.error("上传标号{}报错，跳过此次上传，上传数据：{}", index,JSONObject.toJSONString(rdo));
            }

            log.info("------- 上传标号{} end -------", index);
            ++index;
        }
    }

    /**
     * 组装单个活动记录，对应表格中的一行数据
     *
     * @param rdo                       活动数据
     * @param temporaryActivityPhotoDOS 活动中涉及到的照片（推广、POS）
     * @param activityPhotoDOS（打卡照片）
     */
    private void activityDataToSheetRow(TemporaryActivityReportedDO rdo, List<TemporaryActivityPhotoDO> temporaryActivityPhotoDOS, List<TemporaryActivityPhotoDO> activityPhotoDOS,TemporaryActivityClockDO clockDo) throws Exception {
        List<Object> row = new ArrayList<>();
        // 证明标识（请忽略），一定要在开头第一个单元格有数据，才能保证之后的数据即使缺失也不会串行
        // A-C：证明标识（请忽略） 问题标识（请忽略）	促销员姓名
        row.add("0");
        row.add(rdo.getId());
        row.add(rdo.getTemporaryId() + "-" + rdo.getTemporaryName());
        //2026-1 新增 ： 促销员电话列 D
        row.add(ObjectUtil.isEmpty(rdo.getTemporaryPhone()) ? "" : rdo.getTemporaryPhone());

        // 月份
        String createDate = rdo.getCreateDate();
        String[] dateArr = createDate.split("-");

        // 战区 E
        row.add(rdo.getOrgName());

        // 城市经理 F
        row.add(rdo.getManageName());

        // 执行城市 G
        row.add(rdo.getCity());

        // 执行日期 H
        row.add(dateArr[1] + "月" + dateArr[2] + "日");

        // 场次 I
        row.add("1");

        // 经销商 J
        row.add(rdo.getDealerName());

        // 系统名称 K
        row.add(rdo.getLineName());

        // 勤策门店编码 L
        row.add(clockDo.getQinceStoreCode());

        // 门店名称 M
        row.add(rdo.getStoreName());

        // 活动形式 N
        row.add(rdo.getActivityPattern());

        // 执行方式 O
        row.add(rdo.getExecuteModePlan());

        // 活动品类 P
        row.add(rdo.getPrdClass());

        // 是否提交审核 Q
        row.add("APPROVED".equals(rdo.getApproveStatus()) ? "已审核" : "未提交");

        //配发试吃品是否有黑鸭口味 R
        row.add("1".equals(rdo.getHasBlackDuckFlavor()) ? "有" : "无");

        // 配发黑鸭试吃品（根） S
        row.add(rdo.getBlackDuckTastingNum());
        // 配发苦相试吃品（根） T
        row.add(rdo.getBraisedTastingNum());
        // 配发赠品个数 U
        row.add(rdo.getGiftNum());
        // 推广活动销额（元） V
        row.add(rdo.getPromotionSales());
        // 黑鸭销售 （元）W
        row.add(rdo.getBlackDuckSales());
        // 礼盒+礼袋销量（个）X
        row.add(rdo.getGiftBoxSales());

        // 上传文本数据
        addactivityDataRow(row);

        String rowNumStr = redisCache.get(getRowNumRedisKey());
        if (StringUtils.isBlank(rowNumStr)) {
            log.error("行标识[{}]为未发生改变，当前行不做图片处理，上传数据：{}", rowNumStr, row);
            return;
        }

        String rangFormat = sheetInfoD.getSheetId() + "!%s" + rowNumStr + ":%s" + rowNumStr;

        // Y-AA: 上班打卡时间/地点	午休下班打卡时间/地点	午休上班打卡时间/地点	下班打卡时间/地点
        if (Objects.nonNull(clockDo)) {
            List<Object> rowClockData = new ArrayList<>();
            // 调用新的时长计算方法（两段相加，缺卡则按上下班总时长）
            String workDuration = calculateWorkDuration(clockDo);
            rowClockData.add(workDuration);

            // 打卡时间（AA列）
            StringBuilder timeSb = new StringBuilder();
            if (null != clockDo.getClockInTime()) {
                timeSb.append("上班卡：").append(this.formatDateTime(clockDo.getClockInTime()));
            }
            if (null != clockDo.getNoonClockOutTime()) {
                timeSb.append("、午下卡：").append(this.formatDateTime(clockDo.getNoonClockOutTime()));
            }
            if (null != clockDo.getNoonClockInTime()) {
                timeSb.append("、午上卡：").append(this.formatDateTime(clockDo.getNoonClockInTime()));
            }
            if (null != clockDo.getClockOutTime()) {
                timeSb.append("、下班卡：").append(this.formatDateTime(clockDo.getClockOutTime()));
            }
            rowClockData.add(timeSb.toString());

            // 打卡地点（AB列）
            StringBuilder addrSb = new StringBuilder();
            if (null != clockDo.getClockInAddress()) {
                addrSb.append(clockDo.getClockInAddress());
            }
            if (null != clockDo.getNoonClockOutAddress()) {
                addrSb.append("、").append(clockDo.getNoonClockOutAddress());
            }
            if (null != clockDo.getNoonClockInAddress()) {
                addrSb.append("、").append(clockDo.getNoonClockInAddress());
            }
            if (null != clockDo.getClockOutAddress()) {
                addrSb.append("、").append(clockDo.getClockOutAddress());
            }
            rowClockData.add(addrSb.toString());

            // 调整range为Z-AB列（对应图二上班时长、打卡时间、打卡定位）
            String range = String.format(rangFormat, "Y", "AA");
            updateClockData(range, rowClockData);
        }

        log.info("开始处理上传照片，行号：{}", rowNumStr);
        /**
         * 获取推广、POS图片
         */
        Map<Integer, List<TemporaryActivityPhotoDO>> photoTypeMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(temporaryActivityPhotoDOS)) {
            photoTypeMap = temporaryActivityPhotoDOS.stream().collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getType));
        }


        /**
         * 打卡照片
         * 打卡类型小于9 的  类型大于等于4的 照片
         * 打卡类型大于等于9 的 单独筛选出处理
         */
        Map<Integer, String> clockMap = activityPhotoDOS.stream()
                .filter(photo -> photo.getType() < 9 && photo.getType() >= 4)
                .collect(Collectors.toMap(TemporaryActivityPhotoDO::getType, TemporaryActivityPhotoDO::getPhotoUrl));
        // 上班打卡照片 >>>
        if (clockMap.containsKey(4)) {
            valuesImageToSheet(String.format(rangFormat, "AB", "AB"), clockMap.get(4));
        }

        StringBuilder pct = new StringBuilder();
        List<TemporaryActivityPhotoDO> photosType1 = Objects.isNull(photoTypeMap.get(1)) ? new ArrayList<>() : photoTypeMap.get(1);
        int photosType1Size = photosType1.size();
        // 推广试吃照片1 >>>
        if (!(photosType1Size < 1 || Objects.isNull(photosType1.get(0)))) {
            valuesImageToSheet(String.format(rangFormat, "AC", "AC"), photosType1.get(0).getPhotoUrl());
            pct.append("试吃1："+DateUtil.formatDateTime(photosType1.get(0).getCreateTime()));
        }

        // 推广试吃照片2 >>>
        if (!(photosType1Size < 2 || Objects.isNull(photosType1.get(1)))) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AD", "AD"), photosType1.get(1).getPhotoUrl());
            pct.append("、试吃2："+DateUtil.formatDateTime(photosType1.get(1).getCreateTime()));
        }

        // 推广试吃照片4 >>>
        if (!(photosType1Size < 4 || Objects.isNull(photosType1.get(3)))) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AE", "AE"), photosType1.get(3).getPhotoUrl());
            pct.append("、试吃4："+DateUtil.formatDateTime(photosType1.get(3).getCreateTime()));
        }
        log.info("上传推广-试吃照片完成，行号：{}", rowNumStr);

        // 午休下班打卡照片 >>>
        if (clockMap.containsKey(5)) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AF", "AF"), clockMap.get(5));
        }

        // 午休上班打卡照片 >>>
        if (clockMap.containsKey(6)) {
            valuesImageToSheet(String.format(rangFormat, "AG", "AG"), clockMap.get(6));
        }

        /**
         * 推广试吃照片
         */
        // 推广试吃照片3 >>>
        if (!(photosType1Size < 3 || Objects.isNull(photosType1.get(2)))) {
            valuesImageToSheet(String.format(rangFormat, "AH", "AH"), photosType1.get(2).getPhotoUrl());
            pct.append("、试吃3："+DateUtil.formatDateTime(photosType1.get(2).getCreateTime()));
        }


        /**
         * 推广互动照片
         */
        List<TemporaryActivityPhotoDO> photosType2 = Objects.isNull(photoTypeMap.get(2)) ? new ArrayList<>() : photoTypeMap.get(2);
        int photosType2Size = photosType2.size();
        // 推广互动照片1 >>>
        if (!(photosType2Size < 1 || Objects.isNull(photosType2.get(0)))) {
            valuesImageToSheet(String.format(rangFormat, "AI", "AI"), photosType2.get(0).getPhotoUrl());
            pct.append("、互动1："+DateUtil.formatDateTime(photosType2.get(0).getCreateTime()));
        }


        /**
         * 推广成交照片
         */
        List<TemporaryActivityPhotoDO> photosType3 = Objects.isNull(photoTypeMap.get(3)) ? new ArrayList<>() : photoTypeMap.get(3);
        int photosType3Size = photosType3.size();
        // 推广成交照片1 >>>
        if (!(photosType3Size < 1 || Objects.isNull(photosType3.get(0)))) {
            valuesImageToSheet(String.format(rangFormat, "AJ", "AJ"), photosType3.get(0).getPhotoUrl());
            pct.append("、成交1："+DateUtil.formatDateTime(photosType3.get(0).getCreateTime()));
        }

        Map<Integer, List<TemporaryActivityPhotoDO>> taskMap = activityPhotoDOS.stream()
                .filter(photo -> photo.getType() >= 9)
                .collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getType ));


        // 随机任务照片
        List<TemporaryActivityPhotoDO> randTaskPhotos = taskMap.get(10);
        if (ObjectUtil.isNotEmpty(randTaskPhotos) &&  randTaskPhotos.size() > 0 &&  ObjectUtil.isNotEmpty(randTaskPhotos.get(0))) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AK", "AK"), randTaskPhotos.get(0).getPhotoUrl());
            pct.append("、随机任务："+DateUtil.formatDateTime(randTaskPhotos.get(0).getCreateTime()));
        }


        /**
         * 推广照>> 真实pos证明反馈
         */
        List<TemporaryActivityPhotoDO> photosType8 = Objects.isNull(photoTypeMap.get(8)) ? new ArrayList<>() : photoTypeMap.get(8);
        int photosType8Size = photosType8.size();

        // 真实pos证明反馈1 >>>
        if (!(photosType8Size < 1 || Objects.isNull(photosType8.get(0)))) {
            valuesImageToSheet(String.format(rangFormat, "AL", "AL"), photosType8.get(0).getPhotoUrl());
        }

        // 真实pos证明反馈2 >>>
        if (!(photosType8Size < 2 || Objects.isNull(photosType8.get(1)))) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AM", "AM"), photosType8.get(1).getPhotoUrl());
        }


        // 下班打卡照片 >>>
        if (clockMap.containsKey(7)) {
            valuesImageToSheetByRobot2(String.format(rangFormat, "AN", "AN"), clockMap.get(7));
        }
        log.info("上传打卡照片完成，行号：{}", rowNumStr);
        // 推广类照片上传时间
        String range =String.format(rangFormat, "AO", "AO");
        updateClockData(range,Arrays.asList(pct.toString()));

        log.info("结束上传推广打卡照片：{}",rowNumStr);
    }

    private void addactivityDataRow(List<Object> rowData) {
        String redisKey = getRowNumRedisKey();
        String rowNumStr = redisCache.get(redisKey);
        Integer rowNumNext = StringUtils.isBlank(rowNumStr) ? 2 : Integer.parseInt(rowNumStr) + 1;
        String range = sheetInfoD.getSheetId() + "!A" + rowNumNext + ":X" + rowNumNext;

        Integer rowNumEnd = feishuSheetUtils.appendValueToSheet(range, rowData, sheetInfoD.getSheetToken(), getFeishuTenantToken1());
        if (rowNumEnd < 1) {
            redisCache.removeKey(redisKey);
        } else {
            redisCache.addToMinute(redisKey, rowNumEnd + "", 60);
        }
        log.info("修改文档行号：{}", rowNumEnd);
    }

    private void updateClockData(String range, List<Object> rowData) {
        feishuSheetUtils.updateData(range, rowData, sheetInfoD.getSheetToken(), getFeishuTenantToken2());
    }

    private void valuesImageToSheet(String range, String photoUrl) {
        feishuSheetUtils.valuesImageToSheet(range, photoUrl, sheetInfoD.getSheetToken(), getFeishuTenantToken1());
    }

//    @Async
    private void valuesImageToSheetByRobot2(String range, String photoUrl) {
        feishuSheetUtils.valuesImageToSheet(range, photoUrl, sheetInfoD.getSheetToken(), getFeishuTenantToken2());
    }

    private String getFeishuTenantToken1() {
        String tokenKey = RedisKeys.ExportKeys.FEISHU_TENANT_TOKEN_ACTIVITY_ROBOT_1.getKey();
        String token = redisCache.get(tokenKey);
        if (StringUtils.isNotBlank(token)) {
            return token;
        }

        JSONObject tokenObj = feishuSheetUtils.getFeishuTenantToken(appId1, appSecret1);
        token = tokenObj.getString("tenant_access_token");
        Integer expire = tokenObj.getInteger("expire");
        if (expire <= 110) {
            throw new RuntimeException("获取1号机器人tenant_access_token错误，有效期过短" + tokenObj);
        }
        redisCache.addToSeconds(tokenKey, token, expire - 100);
        return token;
    }

    private String getFeishuTenantToken2() {
        String tokenKey = RedisKeys.ExportKeys.FEISHU_TENANT_TOKEN_ACTIVITY_ROBOT_2.getKey();
        String token = redisCache.get(tokenKey);
        if (StringUtils.isNotBlank(token)) {
            return token;
        }

        JSONObject tokenObj = feishuSheetUtils.getFeishuTenantToken(appId2, appSecret2);
        token = tokenObj.getString("tenant_access_token");
        Integer expire = tokenObj.getInteger("expire");
        if (expire <= 110) {
            throw new RuntimeException("获取2号机器人tenant_access_token错误，有效期过短" + tokenObj);
        }
        redisCache.addToSeconds(tokenKey, token, expire - 100);
        return token;
    }

    private String getRowNumRedisKey() {
        String key = RedisKeys.ExportKeys.ACTIVITY_REPORTED_PUSH_FEISHU_SHEET.getKey();
        return key + DateUtil.today();
    }

    private String formatDateTime(Date date){
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }


    /**
     * 计算工时
     */
    private String calculateWorkDuration(TemporaryActivityClockDO clockDo) {
        // 基础校验：上班/下班时间为空，直接返回0
        if (Objects.isNull(clockDo.getClockInTime()) || Objects.isNull(clockDo.getClockOutTime())) {
            return "0";
        }

        // 上班打卡时间
        Date clockIn = clockDo.getClockInTime();
        // 午休下班时间
        Date noonClockOut = clockDo.getNoonClockOutTime();
        // 午休上班时间
        Date noonClockIn = clockDo.getNoonClockInTime();
        // 下班打卡时间
        Date clockOut = clockDo.getClockOutTime();

        long totalMinutes = 0;

        // 判断是否午休缺卡（午休下班/午休上班任一为空）
        boolean isNoonCardMissing = Objects.isNull(noonClockOut) || Objects.isNull(noonClockIn);
        if (isNoonCardMissing) {
            // 午休缺卡：直接计算上班→下班的总时长
            totalMinutes = DateUtil.between(clockIn, clockOut, DateUnit.MINUTE);
        } else {
            // 午休不缺卡：两段时长相加（上午段 + 下午段）
            // 上班→午休下班
            long morningMinutes = DateUtil.between(clockIn, noonClockOut, DateUnit.MINUTE);
            // 午休上班→下班
            long afternoonMinutes = DateUtil.between(noonClockIn, clockOut, DateUnit.MINUTE);
            totalMinutes = morningMinutes + afternoonMinutes;
        }

        // 分钟转小时（保留1位小数，避免多位小数）
        double hours = totalMinutes / 60.0;
        return String.format("%.1f", hours);
    }


}
