package com.wangxiaolu.export.xxljobtask;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.service.ActivityToFeishuSheetService;
import com.wangxiaolu.export.service.PromotionActivityService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 * 开发步骤：
 *      1、任务开发：在Spring Bean实例中，开发Job方法；
 *      2、注解配置：为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 *      3、执行日志：需要通过 "XxlJobHelper.log" 打印执行日志；
 *      4、任务结果：默认任务结果为 "成功" 状态，不需要主动设置；如有诉求，比如设置任务结果为失败，可以通过 "XxlJobHelper.handleFail/handleSuccess" 自主设置任务结果；
 *
 * @author xuxueli 2019-12-11 21:52:51
 */
@Component
@Slf4j
public class XxlJobHandler {

    @Autowired
    PromotionActivityService promotionActivityService;

    @Autowired
    ActivityToFeishuSheetService activityToFeishuSheetService;

    /**
     * 昨日活动数据上传飞书
     */
    @XxlJob("yesterday_activity_push_feishu")
    public void pushFeishuTask() {
        log.info("============== 活动记录上传飞书 start ==============");
        /**
         * 1>> 查询前一天的活动记录
         */
        String yt = DateUtil.format(DateUtil.yesterday(), DatePattern.NORM_DATE_PATTERN);

        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityListByCreateDate(yt);

        log.info("应上传飞书{}条活动记录",reportedDos.size());

        if (CollectionUtils.isEmpty(reportedDos)){
            log.info("无活动记录，停止上传");
            return;
        }

        List<Long> activityId = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());

        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityId);

        /**
         * 2>> 查询打卡记录
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhotoByCreateDate(yt);
        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end ==============");
    }

}
