package com.wangxiaolu.export.controller.feishu;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.pojo.ActivityVo;
import com.wangxiaolu.export.service.ActivityToFeishuSheetService;
import com.wangxiaolu.export.service.PromotionActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-06-14 11
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/promotion/activity")
public class ActivityToFeishuSheet {

    @Autowired
    PromotionActivityService promotionActivityService;

    @Autowired
    ActivityToFeishuSheetService activityToFeishuSheetService;

    /**
     * 飞书电子表格
     * @param activityVo 查询活动创建日期范围
     */
    @PostMapping("/feishu/sheet")
    public void activityList(@RequestBody ActivityVo activityVo) {

        /**
         * 1>> 查询活动记录
         * 查询当天的记录
         */
        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityList(activityVo);

        log.info("应上传飞书{}条活动记录",reportedDos.size());

        if (CollectionUtils.isEmpty(reportedDos)){
            log.info("无活动记录，停止上传");
            return;
        }

        List<Long> activityIds = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());

        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityIds);
        Map<Long, TemporaryActivityClockDO> clockMap = promotionActivityService.findClockInfoByActivityIds(activityIds);

        /**
         * 2>> 查询打卡图片
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhotoByActivityIds(activityIds);

        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockMap,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end ==============");
    }

    @GetMapping("/feishu/yesterday_sheet")
    public void yesterdayActivityList(){
        log.info("============== 活动记录上传飞书 start ==============");
        /**
         * 1>> 查询前一天的活动记录
         */
        String yt = DateUtil.format(DateUtil.yesterday(), DatePattern.NORM_DATE_PATTERN);

        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityListByCreateDate(yt);

        log.info("应上传飞书{}条活动记录",reportedDos.size());

        if (CollectionUtils.isEmpty(reportedDos)){
            log.info("无活动记录，停止上传");
            return;
        }

        List<Long> activityIds = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());

        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityIds);
        Map<Long, TemporaryActivityClockDO> clockMap = promotionActivityService.findClockInfoByActivityIds(activityIds);

        /**
         * 2>> 查询打卡图片
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhotoByCreateDate(yt);
        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockMap,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end ==============");
    }

    /**
     * @param activityIds 6166L,6181L,6319L,6359L,6431L
     */

    @GetMapping("/feishu/ids_sheet")
    public void idsActivityList(@RequestParam("activityIds") List<Long> activityIds){
        log.info("============== 活动记录上传飞书 start ==============");
        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityListByIds(activityIds);

        log.info("应上传飞书{}条活动记录",reportedDos.size());

        if (CollectionUtils.isEmpty(reportedDos)){
            log.info("无活动记录，停止上传");
            return;
        }

//        List<Long> activityIds = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());

        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityIds);
        Map<Long, TemporaryActivityClockDO> clockMap = promotionActivityService.findClockInfoByActivityIds(activityIds);

        /**
         * 2>> 查询打卡图片
         */
        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhotoByActivityIds(activityIds);

        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        activityToFeishuSheetService.activityDataToFeishuSheet(reportedDos,activityPhotos,clockMap,clockPhotoMap);

        log.info("============== 活动记录上传飞书 end ==============");
    }
}
