package com.wangxiaolu.export.controller.promotion;

import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.export.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.export.pojo.ActivityVo;
import com.wangxiaolu.export.service.PromotionActivityService;
import com.wangxiaolu.export.util.ExcelUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-06-14 11
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/promotion/export")
public class PromotionActivityExport {

    @Autowired
    PromotionActivityService promotionActivityService;

    @PostMapping("/activity")
    public void activityList(HttpServletResponse response, @RequestBody ActivityVo activityVo) {
        log.info("============== 活动记录导出 start ==============");
        List<TemporaryActivityReportedDO> reportedDos = promotionActivityService.findActivityList(activityVo);
        List<Long> activityId = reportedDos.stream().map(TemporaryActivityReportedDO::getId).collect(Collectors.toList());
        Map<Long, List<TemporaryActivityPhotoDO>> activityPhotos = promotionActivityService.findActivityPhotos(activityId);

        List<TemporaryActivityClockDO> clockPhoto = promotionActivityService.findClockPhoto(activityVo);
        Map<String, List<TemporaryActivityPhotoDO>> clockPhotoMap = new HashMap<>();
        clockPhoto.stream().forEach(cp -> {
            clockPhotoMap.put(cp.getTemporaryId() + "-" + cp.getCreateDate(), cp.getPhotoList());
        });


        List<List<Object>> sheet = new ArrayList<>();
        List<Object> headRow = Arrays.asList("月份", "战区", "城市经理", "执行城市", "执行日期", "场次", "系统名称", "门店名称", "活动形式", "推广活动销额（元）",
                "真实pos证明反馈1", "真实pos证明反馈2", "真实pos证明反馈3", "真实pos证明反馈4", "上班打卡照片", "午休下班打卡照片", "午休上班打卡照片", "下班打卡照片", "推广试吃照片1", "推广试吃照片2", "推广试吃照片3", "推广试吃照片4", "推广互动照片1", "推广互动照片2", "推广互动照片3", "推广互动照片4", "推广成交照片1", "推广成交照片2", "推广成交照片3", "推广成交照片4");
        sheet.add(headRow);

        log.info("活动记录查询完成，开始处理表格数据");
        reportedDos.forEach(rdo -> {
            List<Object> row = new ArrayList<>();

            // 月份
            String createDate = rdo.getCreateDate();
            String clockKey = rdo.getTemporaryId() + "-" + createDate;

            String[] dateArr = createDate.split("-");
            row.add(dateArr[1] + "月");

            // 战区
            row.add(rdo.getOrgName());

            // 城市经理
            row.add(rdo.getApproveName());

            // 执行城市
            row.add(rdo.getCity());

            // 执行日期
            row.add(dateArr[1] + "月" + dateArr[2] + "日");

            // 场次
            row.add("1");

            // 系统名称
            row.add(rdo.getLineName());

            // 门店名称
            row.add(rdo.getStoreName());

            // 活动形式
            row.add(rdo.getActivityPattern());

            // 推广活动销额(元)
            row.add("");

            try {
                // 获取推广、POS图片
                List<TemporaryActivityPhotoDO> temporaryActivityPhotoDOS = activityPhotos.get(rdo.getId());
                Map<Integer, List<TemporaryActivityPhotoDO>> photoTypeMap = new HashMap<>();
                if (!CollectionUtils.isEmpty(temporaryActivityPhotoDOS)) {
                    photoTypeMap = temporaryActivityPhotoDOS.stream().collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getType));
                }

                /**
                 * 真实pos证明反馈
                 */
                List<TemporaryActivityPhotoDO> photosType7 = Objects.isNull(photoTypeMap.get(7)) ? new ArrayList<>() : photoTypeMap.get(7);
                int photosType7Size = photosType7.size();

                // 真实pos证明反馈1
                URL url1 = photosType7Size < 1 || Objects.isNull(photosType7.get(0)) ? null : new URL(photosType7.get(0).getPhotoUrl());
                row.add(url1);

                // 真实pos证明反馈2
                URL url2 = photosType7Size < 2 || Objects.isNull(photosType7.get(1)) ? null : new URL(photosType7.get(1).getPhotoUrl());
                row.add(url2);

                // 真实pos证明反馈3
                URL url3 = photosType7Size < 3 || Objects.isNull(photosType7.get(2)) ? null : new URL(photosType7.get(2).getPhotoUrl());
                row.add(url3);

                // 真实pos证明反馈4
                URL url4 = photosType7Size < 4 || Objects.isNull(photosType7.get(3)) ? null : new URL(photosType7.get(3).getPhotoUrl());
                row.add(url4);

                /**
                 * 打卡照片
                 */
                List<TemporaryActivityPhotoDO> activityClock = clockPhotoMap.containsKey(clockKey) ? clockPhotoMap.get(clockKey) : new ArrayList<>();
                Map<Integer, String> clockMap = activityClock.stream().collect(Collectors.toMap(TemporaryActivityPhotoDO::getType, TemporaryActivityPhotoDO::getPhotoUrl));
                // 上班打卡照片
                row.add(clockMap.containsKey(4) ? new URL(clockMap.get(4)) : null);

                // 午休下班打卡照片
                row.add(clockMap.containsKey(5) ? new URL(clockMap.get(5)) : null);

                // 午休上班打卡照片
                row.add(clockMap.containsKey(6) ? new URL(clockMap.get(6)) : null);

                // 下班打卡照片
                row.add(clockMap.containsKey(7) ? new URL(clockMap.get(7)) : null);

                /**
                 * 推广试吃照片
                 */
                List<TemporaryActivityPhotoDO> photosType1 = Objects.isNull(photoTypeMap.get(1)) ? new ArrayList<>() : photoTypeMap.get(1);
                int photosType1Size = photosType1.size();
                // 推广试吃照片1
                URL url1_1 = photosType1Size < 1 || Objects.isNull(photosType1.get(0)) ? null : new URL(photosType1.get(0).getPhotoUrl());
                row.add(url1_1);

                // 推广试吃照片2
                URL url1_2 = photosType1Size < 2 || Objects.isNull(photosType1.get(1)) ? null : new URL(photosType1.get(1).getPhotoUrl());
                row.add(url1_2);

                // 推广试吃照片3
                URL url1_3 = photosType1Size < 3 || Objects.isNull(photosType1.get(2)) ? null : new URL(photosType1.get(2).getPhotoUrl());
                row.add(url1_3);

                // 推广试吃照片4
                URL url1_4 = photosType1Size < 4 || Objects.isNull(photosType1.get(3)) ? null : new URL(photosType1.get(3).getPhotoUrl());
                row.add(url1_4);

                /**
                 * 推广互动照片
                 */
                List<TemporaryActivityPhotoDO> photosType2 = Objects.isNull(photoTypeMap.get(2)) ? new ArrayList<>() : photoTypeMap.get(2);
                int photosType2Size = photosType2.size();
                // 推广互动照片1
                URL url2_1 = photosType2Size < 1 || Objects.isNull(photosType2.get(0)) ? null : new URL(photosType2.get(0).getPhotoUrl());
                row.add(url2_1);

                // 推广互动照片2
                URL url2_2 = photosType2Size < 2 || Objects.isNull(photosType2.get(1)) ? null : new URL(photosType2.get(1).getPhotoUrl());
                row.add(url2_2);

                // 推广互动照片3
                URL url2_3 = photosType2Size < 3 || Objects.isNull(photosType2.get(2)) ? null : new URL(photosType2.get(2).getPhotoUrl());
                row.add(url2_3);

                // 推广互动照片4
                URL url2_4 = photosType2Size < 4 || Objects.isNull(photosType2.get(3)) ? null : new URL(photosType2.get(3).getPhotoUrl());
                row.add(url2_4);

                /**
                 * 推广成交照片
                 */
                List<TemporaryActivityPhotoDO> photosType3 = Objects.isNull(photoTypeMap.get(3)) ? new ArrayList<>() : photoTypeMap.get(3);
                int photosType3Size = photosType3.size();
                // 推广成交照片1
                URL url3_1 = photosType3Size < 1 || Objects.isNull(photosType3.get(0)) ? null : new URL(photosType3.get(0).getPhotoUrl());
                row.add(url3_1);


                // 推广成交照片2
                URL url3_2 = photosType3Size < 2 || Objects.isNull(photosType3.get(1)) ? null : new URL(photosType3.get(1).getPhotoUrl());
                row.add(url3_2);


                // 推广成交照片3
                URL url3_3 = photosType3Size < 3 || Objects.isNull(photosType3.get(2)) ? null : new URL(photosType3.get(2).getPhotoUrl());
                row.add(url3_3);


                // 推广成交照片4
                URL url3_4 = photosType3Size < 4 || Objects.isNull(photosType3.get(3)) ? null : new URL(photosType3.get(3).getPhotoUrl());
                row.add(url3_4);

            } catch (MalformedURLException e) {
                log.error("获取图片错误(MalformedURLException)，抛出异常：{}", e.getMessage());
            }
            sheet.add(row);
        });

        log.info("活动记录数据处理完成，开始导出");
        ExcelUtils.export(response, "活动数据导出_"+ DateUtil.today(), sheet);
        log.info("============== 活动记录导出 end ==============");
    }

}
