package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionManageEmployeeDao;
import com.wangxiaolu.promotion.domain.activity.mapper.PromotionManageEmployeeMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.PromotionManageEmployeeDO;
import com.wangxiaolu.promotion.pojo.user.dto.PromotionManageEmployeeDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
public class PromotionManageEmployeeDaoImpl implements PromotionManageEmployeeDao {

    @Autowired
    PromotionManageEmployeeMapper promotionManageEmployeeMapper;

    @Override
    public PromotionManageEmployeeDto selectOneByEmployeeNo(String employeeNo) {
        LambdaQueryWrapper<PromotionManageEmployeeDO> lqw = new LambdaQueryWrapper();
        lqw.eq(PromotionManageEmployeeDO::getEmployeeNo,employeeNo);

        PromotionManageEmployeeDO promotionManageEmployeeDO = promotionManageEmployeeMapper.selectOne(lqw);
        return transitionDto(promotionManageEmployeeDO);
    }

    private PromotionManageEmployeeDto transitionDto(PromotionManageEmployeeDO employeeDO) {
        PromotionManageEmployeeDto dto = null;
        if (Objects.isNull(employeeDO)) {
            return dto;
        }
        dto = new PromotionManageEmployeeDto();
        BeanUtils.copyProperties(employeeDO, dto);
        return dto;
    }
}
