package com.wangxiaolu.promotion.controller.activity.employee;

import com.wangxiaolu.promotion.pojo.activity.employee.vo.ClockVo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeCoreTemClockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-07-17 19
 * @describe : 管理员修改员工打卡信息
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/core/clock")
public class EmployeeCoreTemClockController {

    @Autowired
    EmployeeCoreTemClockService employeeCoreTemClockService;

    // 修改员工打卡形式
    @PutMapping("/update")
    public R updateClockactivityPattern(@RequestBody ClockVo clockVo) {
        TemporaryClockDto temporaryClockDto = new TemporaryClockDto();
        temporaryClockDto.setId(clockVo.getId())
                .setActivityPatternId(clockVo.getActivityPatternId())
                .setActivityPattern(clockVo.getActivityPattern());

        employeeCoreTemClockService.updateClockactivityPattern(temporaryClockDto);
        return R.success();
    }


}
