package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeCoreTemClockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-07-18 13
 * @describe :
 */
@Service
@Slf4j
public class EmployeeCoreTemClockServiceImpl implements EmployeeCoreTemClockService {

    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;
    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateClockactivityPattern(TemporaryClockDto temporaryClockDto) {
        TemporaryClockDto clockDto = temporaryActivityClockDao.selectById(temporaryClockDto.getId());
        if (Objects.isNull(clockDto)){
           throw new DataException(RCode.DATA_NOT_HAVE_ERROR);
        }

        temporaryActivityClockDao.updateById(temporaryClockDto);

        TemporaryActivityReportedDto reportedDto = new TemporaryActivityReportedDto();
        reportedDto.setId(clockDto.getReportedId())
                .setActivityPatternId(temporaryClockDto.getActivityPatternId())
                .setActivityPattern(temporaryClockDto.getActivityPattern());

        temporaryActivityReportedDao.updateById(reportedDto);
    }

}
