package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.wangxiaolu.promotion.utils.WechatAccessTokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;


/**
 * 微信订阅消息服务
 */
@Service
@Slf4j
public class SubscribeMessageService {
    @Value("${wx.cx_miniapp.miniprogram_state:formal}")
    private String miniprogramState;

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WechatAccessTokenUtil tokenUtil;

    /**
     * 发送订阅通知
     * @param openid 用户openid
     * @param templateId 订阅模板ID
     * @param page 点击通知跳转的小程序页面（如 "/pages/order/detail?id=123"）
     * @param data 模板数据（键为模板中的字段名，值为具体内容）
     * @return 发送结果
     */
    public boolean sendSubscribeMessage(String openid, String templateId, String page, Map<String, String> data) {
        try {
            // 构建请求参数
            Map<String, Object> requestBody = new HashMap<>();
            // 用户openid
            requestBody.put("touser", openid);
            // 模板ID
            requestBody.put("template_id", templateId);
            // 跳转页面
            requestBody.put("page", page);
            // 跳转小程序类型:developer为开发版;trial为体验版;formal为正式版;默认为正式版
            requestBody.put("miniprogram_state", miniprogramState);

            // 格式化模板数据（微信要求格式：{"字段名":{"value":"内容"}}）
            Map<String, Map<String, String>> dataMap = new HashMap<>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                Map<String, String> valueMap = new HashMap<>();
                valueMap.put("value", entry.getValue());
                dataMap.put(entry.getKey(), valueMap);
            }
            requestBody.put("data", dataMap);

            // 获取access_token，拼接完整URL
            String accessToken = tokenUtil.getStableAccessToken();
            // 发送订阅通知的API地址
            String url =  "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token="+ accessToken;

            // 发送POST请求
            String response = restTemplate.postForObject(url, requestBody, String.class);
            log.info("发送微信通知,url:{},requestBody:{},response:{}",url, JSON.toJSONString(requestBody),response);
            JSONObject json = new JSONObject(response);
            log.info("微信返回数据:{} ",json.toString());
            int errcode = json.getInt("errcode");
            // 0表示成功
            return errcode == 0;
        } catch (Exception e) {
            log.error("发送微信订阅通知失败", e);
            return false;
        }
    }
}
