package com.wangxiaolu.promotion.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;

/**
 * @author : liqiulin
 * @date : 2024-03-29 15
 * @describe :
 */
@SpringBootTest
@RunWith(SpringRunner.class)
class OkHttpTest {

    @Autowired
    QinCeUtils qinCeUtils;

    @Test
    void postDepartment() {
        // 查询组织架构参数
        Map<String, Object> params = qinCeUtils.queryOrgParam();

        // 创建url
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_ORGANIZATION,params);
        System.out.println(url);

        // 发起请求
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        for (Object responseData : responseDatas) {
            System.out.println(responseData);
        }
        System.out.println(resultJson);

    }


    @Test
    void postEmployee() {
        // 查询组织架构参数
        Map<String, Object> params = qinCeUtils.queryEmployeeParam(0);

        // 创建url
        String url = qinCeUtils.builderUrl(QinCeUtils.QUERY_EMPLOYEE,params);
        System.out.println(url);

        // 发起请求
        JSONObject resultJson = OkHttp.postQC(url, params);
        JSONArray responseDatas = resultJson.getJSONArray("response_data");
        for (Object responseData : responseDatas) {
            System.out.println(responseData);
        }
        System.out.println(resultJson);

    }
}