package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.common.enums.FlagType;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityTaskClockReq;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 临时活动相关任务打卡核心控制层
 * 包含 随机任务和pos打卡任务
 */
@RestController
@RequestMapping("/activity/task-clock/core")
public class TemporaryActivityTaskClockCoreController {

    @Resource
    private TemporaryActivityTaskClockService service;

    /**
     * 打卡更新打卡状态
     *
     * @param clockVo
     * @return
     */
    @PostMapping("/clock")
    public R clock(@RequestBody TemporaryActivityTaskClockReq clockVo) {
        service.taskClock(clockVo);
        return R.success();
    }

    @PutMapping("/update")
    public R update(@RequestBody TemporaryActivityTaskClockDO taskClock) {
        return R.success(service.updateById(taskClock));
    }

    @DeleteMapping("/delete/{id}")
    public R delete(@PathVariable Long id) {
        TemporaryActivityTaskClockDO taskClock = new TemporaryActivityTaskClockDO();
        taskClock.setClockId(id)
                .setIsDelete(FlagType.NO.getType());
        return R.success(service.updateById(taskClock));
    }
}
