package com.wangxiaolu.promotion.controller.activity.manage;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.manage.EmpPromotionStoreQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-06-26 16
 * @describe : 员工后台查询店铺列表
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/query/store")
public class EmpPromotionStoreQueryController {

    @Autowired
    EmpPromotionStoreQueryService empPromotionStoreQueryService;

    /**
     * 分页查询店铺
     */
    @PostMapping("/page")
    public R findStorePage(@RequestBody PageInfo pageInfo) {
        empPromotionStoreQueryService.findStorePage(pageInfo);
        return R.success(pageInfo);
    }
}
