package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityDataVo;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityMarketCellVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockCoreService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员活动上报、修改
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/core")
public class TemporaryActivityCoreController {
    @Autowired
    private TemporaryActivityCoreService tempActivityCoreService;
    @Autowired
    private TemporaryActivityClockQueryService tempActivityClockQueryService;

    @Autowired
    private TemporaryActivityClockCoreService tempActivityClockCoreService;

    /**
     * 促销员[今日活动]数据保存
     * 返回活动生成id
     */
    @Transactional(rollbackFor = Exception.class)
    @PostMapping("/today/reported")
    public R todayActivityDataReported(@RequestBody TemporaryActivityDataVo activityVo) {
        if (Objects.isNull(activityVo.getTemporaryId())){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR);
        }
        TemporaryActivityReportedDto temActDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(activityVo, temActDto);
        temActDto.setId(activityVo.getActivityReportedId());

        /**
         * 已有id，修改任务
         */
        if (Objects.nonNull(activityVo.getActivityReportedId())) {
            tempActivityCoreService.activityDataReportedUpdate(temActDto);
            return R.success(activityVo.getActivityReportedId());
        }

        /**
         * 新增任务
         */
        TemporaryClockDto clockDto = tempActivityClockQueryService.findTodayTemporaryClockByTemId(temActDto.getTemporaryId());
        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED)
                .setDealerName(clockDto.getDealerName())
                .setLineName(clockDto.getLineName())
                .setPlanId(clockDto.getPlanId())
                .setStoreName(clockDto.getStoreName())
                .setDeptQcId(clockDto.getDeptQcId())
                .setDeptQcOrgName(clockDto.getDeptQcOrgName())
                .setManageId(clockDto.getChargerId())
                .setManageName(clockDto.getChargerName())
                .setActivityPattern(clockDto.getActivityPattern())
                .setProvince(clockDto.getClockProvince())
                .setCity(clockDto.getClockCity());

        long reportedId = tempActivityCoreService.activityDataReportedSave(temActDto);

        TemporaryClockDto clockDtoUpdate = new TemporaryClockDto();
        clockDtoUpdate.setId(clockDto.getId()).setReportedId(reportedId);
        tempActivityClockCoreService.updateById(clockDtoUpdate);
        return R.success(reportedId);
    }

    /**
     * 促销员[今日活动 - （出售列表中添加）出售单元]数据
     * 数据暂存到redis中，当调用保存接口时再添加到数据库中
     * 返回保存成功信息
     */
    @PostMapping("/today/reported/market_cell")
    public R todayActivityMarketCellReported(@RequestBody TemporaryActivityMarketCellVo marketcellVo) {
        marketcellVo.saveDataVerify();
        tempActivityCoreService.todayActivityMarketCellReported(marketcellVo);
        return R.success();
    }

    /**
     * 修改/删除促销员[今日活动 - （出售列表中添加）出售单元]某一条数据
     */
    @PutMapping("/today/reported/market_cell/one")
    public R todayUpdateMarketCellOne(@RequestBody TemporaryActivityMarketCellVo marketcellVo) {
        marketcellVo.updateDataVerify();
        tempActivityCoreService.todayUpdateMarketCellOne(marketcellVo);
        return R.success();
    }

    /**
     * 删除促销员[今日活动 - （出售列表中添加）出售单元]在缓存中的全部数据
     * 当促销员取消保存活动记录时，数据进行删除
     */
    @DeleteMapping("/today/reported/market_cell/del")
    public R todayDeleteMarketCellReported(Integer temporaryId) {
        tempActivityCoreService.todayActivityDeleteMarketCellReported(temporaryId);
        return R.success();
    }

    /**
     * 促销员[今日活动]数据提交审批
     * 修改审批状态
     */
    @PutMapping("/reported/approve/submit/{id}")
    public R activityReportedSubmit(@PathVariable("id") Long id) {
        tempActivityCoreService.activityReportedSubmit(id);
        return R.success();
    }

}
