package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.user.dao.WxTemporaryInfoDelayDao;
import com.wangxiaolu.promotion.domain.user.mapper.WxTemporaryInfoDelayMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.WxTemporaryInfoDelayDO;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.WxTemporaryInfoDelayDtO;
import org.springframework.stereotype.Component;
import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class WxTemporaryInfoDelayDaoImpl implements WxTemporaryInfoDelayDao {

    @Resource
    private WxTemporaryInfoDelayMapper delayMapper;

    @Override
    public List<WxTemporaryInfoDelayDtO> selectUnprocessedData(LocalDateTime startTime, LocalDateTime endTime) {
        // 1. 查询数据库获取DO列表
        List<WxTemporaryInfoDelayDO> wxTemporaryInfoDelayDOS = delayMapper.selectByTimeAndStatus(startTime, endTime, 0);

        // 2. 调用类内的通用转换方法完成DO转DTO
        return copyListProperties(wxTemporaryInfoDelayDOS, WxTemporaryInfoDelayDtO.class);
    }

    @Override
    public int insert(WxTemporaryInfoDelayDtO delayEntity) {
        WxTemporaryInfoDelayDO delayDO = new WxTemporaryInfoDelayDO();
        BeanUtils.copyProperties(delayEntity, delayDO);
        return delayMapper.insert(delayDO);
    }

    @Override
    public int batchUpdateProcessedStatus(List<Long> idList, Integer isProcessed) {
        if (idList == null || idList.isEmpty()) {
            return 0;
        }
        return delayMapper.batchUpdateStatus(idList, isProcessed);
    }

    private <S, T> List<T> copyListProperties(List<S> sourceList, Class<T> targetClass) {
        // 空值判断，避免空指针
        if (sourceList == null || sourceList.isEmpty()) {
            return new ArrayList<>();
        }

        // 批量转换源列表为目标列表
        return sourceList.stream()
                .map(source -> {
                    try {
                        // 反射创建目标对象实例
                        T target = targetClass.getDeclaredConstructor().newInstance();
                        // 拷贝属性
                        BeanUtils.copyProperties(source, target);
                        return target;
                    } catch (InstantiationException | IllegalAccessException | NoSuchMethodException |
                             InvocationTargetException e) {
                        // 转换失败抛出运行时异常，便于排查问题
                        throw new RuntimeException("对象列表转换失败，目标类：" + targetClass.getName(), e);
                    }
                })
                .collect(Collectors.toList());
    }
}