package com.wangxiaolu.promotion.result.basedata;

import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe : 返回状态编码
 */
@Getter
public enum RCode implements StatusCode {
    /**
     * 程序统一编码（不分模块）
     * 1000+
     */
    SUCCESS(0, "请求成功"),
    FAILED(1001, "请求失败"),
    PARAM_ERROR(1002, "参数错误"),
    RESPONSE_PACK_ERROR(1003, "包装R失败"),

    /**
     * 业务统一编码（不分模块）
     * 2000+
     */
    API_ERROR(2000, "业务异常"),
    API_DATA_ERROR(2001, "业务数据异常"),

    /**
     * user
     * 3000+
     */
    LOGIN_PARAM_ERROR(3000, "登录信息错误"),
    ENROLL_PARAM_ERROR(3001, "注册信息错误"),
    PHONE_PARAM_ERROR(3002, "手机号异常"),
    USER_PHONE_IDENNUMBER_WXOPENID_UNIQUE_ERROR(3003, "个人信息已注册"),
    LOGIN_USER_IS_NULL_ERROR(3004, "账号未注册"),
    /**
     * 腾讯云
     * 3500+
     */
    TENCENT_SMS_ERROR(3500, "短信发送失败"),
    TENCENT_SMS_REPETITION(3501, "短信已发送"),
    TENCENT_SMS_PHONE_CODE_ERROR(3502, "验证码错误"),
    ;


    private int code;
    private String msg;

    RCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
