package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import cn.hutool.json.JSON;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;

import com.wangxiaolu.promotion.enums.activity.LogType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @TableName temporary_activity_log
 * 【促销员活动类】信息日志
 */
@TableName(value = "temporary_activity_log")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TemporaryActivityLogDO implements Serializable {
    /**
     *
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * temporary_info表id
     */
    private Long temporaryId;

    /**
     * 促销员姓名
     */
    private String temporaryName;

    /**
     * 日志所在业务类型
     */
    private Integer type;

    /**
     * 日志所在业务名称
     */
    private String typeName;

    /**
     * 当前日志所属业务数据的id
     */
    private Long flowDataId;

    /**
     * 日志内容
     */
    private Object dataDetail;

    /**
     * 创建时间
     */
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public TemporaryActivityLogDO(Long temporaryId, String temporaryName, LogType typeE, Long flowDataId, Object dataDetail) {
        this.temporaryId = temporaryId;
        this.type = typeE.getType();
        this.typeName = typeE.getName();
        this.dataDetail = dataDetail;
        this.temporaryName = temporaryName;
        this.flowDataId = flowDataId;
    }
}
