package com.wangxiaolu.promotion.controller.user.employee;

import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.ManageEmployeeCoreService;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-01-13 13
 * @describe :
 */
@RestController
@RequestMapping("/user/employee/core")
public class ManageEmployeeCoreController {

    @Autowired
    ManageEmployeeQueryService manageEmployeeQueryService;
    @Autowired
    ManageEmployeeCoreService manageEmployeeCoreService;

    /**
     * 操作业务员账号
     * 开通、关闭、修改权限
     */
    @PostMapping ("/account")
    public R openEmployeeAccount(@RequestBody UserLoginParam param) {
        param.valLoginName();
        if (Objects.isNull(param.getPrivilegeId())) {
            return R.fail(RCode.EMP_PRIVILEGE_ERROR);
        }
        // 开通新账号、修改账号（账号信息、权限）
        boolean hasEmp = manageEmployeeQueryService.hasByEmpNo(param.getLoginName());
        if (hasEmp) {
            manageEmployeeCoreService.putAccount(param);
        }else {
            manageEmployeeCoreService.openAccount(param);
        }
        return R.success();
    }





}
