package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ManageEmployeeVo;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-09-20 11
 * @describe :
 */
@Service
public class ManageEmployeeQueryServiceImpl implements ManageEmployeeQueryService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    ManageEmployeeInfoDao manageEmployeeInfoDao;

    @Override
    public LoginVo employeeLoginVerify(UserLoginParam userLoginParam) {
        ManageEmployeeInfoDto employeeDto = manageEmployeeInfoDao.loginByEmployeeNo(userLoginParam.getLoginName(),userLoginParam.getPassword());
        String loginToken = jwtUtils.getEmployeeToken(userLoginParam.getLoginName(), userLoginParam.getPassword());
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey()+loginToken,employeeDto,360);
        LoginVo loginVo = new LoginVo<>(employeeDto,loginToken);
        return loginVo;
    }

    @Override
    public ManageEmployeeInfoDto findOne(ManageEmployeeVo manageEmployeeVo) {
        ManageEmployeeWrapper ewrap = new ManageEmployeeWrapper();
        BeanUtils.copyProperties(manageEmployeeVo,ewrap);
        return manageEmployeeInfoDao.selectOne(ewrap);
    }

    @Override
    public List<ManageEmployeeInfoDto> findList(ManageEmployeeVo manageEmployeeVo) {
        ManageEmployeeWrapper wrap = new ManageEmployeeWrapper();
        BeanUtils.copyProperties(manageEmployeeVo,wrap);
        return manageEmployeeInfoDao.selectList(wrap);
    }

    @Override
    public boolean hasByEmpNo(String employeeNo) {
        return manageEmployeeInfoDao.hasByEmpNo(employeeNo);
    }

    @Override
    public boolean isOneSelf(String employeeNo) {
        return manageEmployeeInfoDao.isOneSelf(employeeNo);
    }

    @Override
    public boolean isAuth(String employeeNo) {
        return manageEmployeeInfoDao.isAuth(employeeNo);
    }
}
