package com.wangxiaolu.promotion.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-05-09 11
 * @describe : 活动照片图片类型
 */
@Getter
@AllArgsConstructor
public enum ActivityPhotoType {
    /**
     * 推广试吃照片
     */
    TGSC(1),
    /**
     * 推广互动照片
     */
    TGHD(2),
    /**
     * 推广成交照片
     */
    TGCJ(3),
    /**
     * 上班打卡图片
     */
    CLOCK_IN(4),
    /**
     * 午休下班打卡图片
     */
    NOON_CLOCK_OUT(5),
    /**
     * 午休上班打卡图片
     */
    NOON_CLOCK_IN(6),
    /**
     * 下班打卡图片
     */
    CLOCK_OUT(7),
    /**
     * 试吃照片
     */
    TASTY_PHOTO(8),
    /**
     * 当日销量POS机页面凭证
     */
    POS_SELL_VOUCHER(9),

    /**
     * 高峰期在岗
     * 更改固定任务：下午18点15任务
     */
    RANDOM_TASK(10),
    /**
     * 配发赠品照片
     */
    SEND_GIFT_PHOTO(11),

    TASTY_MATERIALS(12)
    ;

    private int type;
}
