package com.wangxiaolu.promotion.domain.activityplanv2.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.ActivityPlanInfoMapper;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfoDo;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-02-06 11
 * @describe :
 */
@Service
public class ActivityPlanInfoDaoImpl implements ActivityPlanInfoDao {

    @Autowired
    private ActivityPlanInfoMapper activityPlanInfoMapper;

    @Override
    public void saveList(JSONArray table, Long recordId) {
        try {
            activityPlanInfoMapper.saveList(table, recordId);
        } catch (PersistenceException e) {
            e.printStackTrace();
            throw new DataException(RCode.ACTIVITY_PLAN_REPETITION_ERROR);
        }
    }



    @Override
    public void updateList(JSONArray table, Long recordId) {
        try {
            // 将table中的数据转换为ActivityPlanInfoDo
            for (int i = 0; i < table.size(); i++) {
                ActivityPlanInfoDo pdo = table.getObject(i, ActivityPlanInfoDo.class);
                activityPlanInfoMapper.updateOne(pdo, recordId);
            }
        } catch (PersistenceException e) {
            e.printStackTrace();
            throw new DataException(RCode.ACTIVITY_PLAN_REPETITION_ERROR);
        }
    }

    @Override
    public ActivityPlanInfoDto selectById(Long id) {
        ActivityPlanInfoDo activityPlanInfoDo = activityPlanInfoMapper.selectById(id);
        return BeanUtils.transitionDto(activityPlanInfoDo, ActivityPlanInfoDto.class);
    }

    @Override
    public void updateById(ActivityPlanInfoDto planDto) {
        ActivityPlanInfoDo planDo = BeanUtils.transitionDto(planDto, ActivityPlanInfoDo.class);
        activityPlanInfoMapper.updateById(planDo);
    }

    @Override
    public void save(ActivityPlanInfoDto planDto) {
        ActivityPlanInfoDo planDo = new ActivityPlanInfoDo();
        BeanUtils.copyProperties(planDto,planDo);
        activityPlanInfoMapper.insert(planDo);
    }

    @Override
    public List<ActivityPlanInfoDto> findList(ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<ActivityPlanInfoDo> qw = buildWrapper(wrapper);
        List<ActivityPlanInfoDo> activityPlanInfoDos = activityPlanInfoMapper.selectList(qw);
        return BeanUtils.transitionDtos(activityPlanInfoDos, ActivityPlanInfoDto.class);
    }

    @Override
    public void updatePlanStatus(Long planId, PlanStatus planStatus) {
        activityPlanInfoMapper.updatePlanStatus(planId,planStatus.getCode());
    }

    @Override
    public void page(PageInfo pageInfo, ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<ActivityPlanInfoDo> qw = buildWrapper(wrapper);
        Page<ActivityPlanInfoDo> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<ActivityPlanInfoDo> doPage =  activityPlanInfoMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(doPage.getRecords());
    }

    @Override
    public ActivityPlanInfoDto selectPlan(String storeCode, Date date) {
        ActivityPlanInfoDo activityPlanInfoDo = activityPlanInfoMapper.selectPlan(storeCode, date);
        return BeanUtils.transitionDto(activityPlanInfoDo, ActivityPlanInfoDto.class);
    }

    @Override
    public void deleteByPlanIds(List<Long> planIds, String employeeNo) {
        // 判断ID中是否包含之前数据、非个人数据
        Integer count = activityPlanInfoMapper.selectNotDelCount(planIds,employeeNo);
        if (count > 0 ) {
            throw new DataException(RCode.ACTIVITY_PLAN_NOT_SELF_DELETE);
        }
        Integer countToday = activityPlanInfoMapper.selectTodayCount(planIds);
        // 今日数据存在时，判断当前时间是否在今日10点前
        if (countToday > 0 && (LocalTime.now().getHour() >= 10)) {
            throw new DataException(RCode.ACTIVITY_PLAN_NOT_DELETE);
        }
        activityPlanInfoMapper.updateIsDelete(planIds);
    }

    /**
     * todo
     * @param wrapper
     * @return
     */

    private LambdaQueryWrapper<ActivityPlanInfoDo> buildWrapper(ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<ActivityPlanInfoDo> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wrapper.getActivityStartDate()) && Objects.nonNull(wrapper.getActivityEndDate())){
            qw.between(ActivityPlanInfoDo::getDate, wrapper.getActivityStartDate(), wrapper.getActivityEndDate());
        }
        if (Objects.nonNull(wrapper.getActivityDate())){
            qw.eq(ActivityPlanInfoDo::getDate, wrapper.getActivityDate());
        }
        if (Objects.nonNull(wrapper.getEmployeeId())) {
            qw.eq(ActivityPlanInfoDo::getEmployeeId, wrapper.getEmployeeId());
        }
        if (StringUtils.isNotBlank(wrapper.getProvince())) {
            qw.eq(ActivityPlanInfoDo::getProvince, wrapper.getProvince());
        }
        if (StringUtils.isNotBlank(wrapper.getCity())) {
            qw.eq(ActivityPlanInfoDo::getCity, wrapper.getCity());
        }
        if (StringUtils.isNotBlank(wrapper.getArea())) {
            qw.eq(ActivityPlanInfoDo::getArea, wrapper.getArea());
        }
        if (StringUtils.isNotBlank(wrapper.getDealerId())) {
            qw.eq(ActivityPlanInfoDo::getDealerId, wrapper.getDealerId());
        }
        if (Objects.nonNull(wrapper.getPlanStatus())) {
            qw.eq(ActivityPlanInfoDo::getPlanStatus, wrapper.getPlanStatus().getCode());
        }
        if (StringUtils.isNotBlank(wrapper.getOrgQcId())){
            qw.eq(ActivityPlanInfoDo::getOrgQcId, wrapper.getOrgQcId());
        }
        if (StringUtils.isNotBlank(wrapper.getStoreNameLike())) {
            qw.like(ActivityPlanInfoDo::getStoreName, wrapper.getStoreNameLike());
        }
        qw.eq(ActivityPlanInfoDo::getIsDelete, StatusType.VALID.getType());
        qw.orderByDesc(ActivityPlanInfoDo::getDate);
        return qw;
    }


}
