package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.TemporaryInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.domain.user.wrapperQo.TemporaryWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :促销员-信息
 */
@Service
public class TemporaryInfoDaoImpl implements TemporaryInfoDao {

    @Autowired
    TemporaryInfoMapper temporaryInfoMapper;

    /**
     * 微信-小程序注册的促销员信息
     */
    @Override
    public int saveWxTemporaryInfo(WxTemporaryInfoDto temporaryDto) {
        try {
            TemporaryInfoDO entity = new TemporaryInfoDO();
            BeanUtils.copyProperties(temporaryDto, entity);
            int insert = temporaryInfoMapper.insert(entity);
            return insert;
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'open_id_unique'")) {
                throw new ParamException(RCode.USER_WXOPENID_UNIQUE_ERROR);
            } else if (eMsg.contains("for key 'phone_unique'")) {
                throw new ParamException(RCode.USER_PHONE_UNIQUE_ERROR);
            }
            throw new ParamException(RCode.USER_PHONE_UNIQUE_ERROR);
        }
    }

    @Override
    public WxTemporaryInfoDto selectOneByOpenId(String openId) {
        TemporaryWrapper tw = new TemporaryWrapper().setOpenId(openId);
        LambdaQueryWrapper<TemporaryInfoDO> doqwer = buildQueryList(tw);
        TemporaryInfoDO temDo = temporaryInfoMapper.selectOne(doqwer);
        return transitionDto(temDo);
    }

    @Override
    public WxTemporaryInfoDto selectOneById(Long id) {
        TemporaryInfoDO temDo = temporaryInfoMapper.selectById(id);
        return transitionDto(temDo);
    }

    @Override
    public void findPage(TemporaryWrapper tw, PageInfo pageInfo) {
        LambdaQueryWrapper<TemporaryInfoDO> qw = buildQueryList(tw);
        Page<TemporaryInfoDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());

        Page<TemporaryInfoDO> doPage = temporaryInfoMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(transitionDtos(doPage.getRecords()));
    }

    @Override
    public void updateById(WxTemporaryInfoDto temporaryDto) {
        TemporaryInfoDO entity = new TemporaryInfoDO();
        BeanUtils.copyProperties(temporaryDto, entity);
        temporaryInfoMapper.updateById(entity);
    }

    @Override
    public WxTemporaryInfoDto selectByPhone(String phone) {
        TemporaryWrapper tw = new TemporaryWrapper().setPhone(phone);
        LambdaQueryWrapper<TemporaryInfoDO> doqwer = buildQueryList(tw);
        TemporaryInfoDO temDo = temporaryInfoMapper.selectOne(doqwer);
        return transitionDto(temDo);
    }

    @Override
    public int saveWxUserStoreInfoTemporary(WxTemporaryInfoDto temporaryDto) {

        TemporaryInfoDO entity = new TemporaryInfoDO();
        BeanUtils.copyProperties(temporaryDto, entity);
        return temporaryInfoMapper.updateById(entity);
    }

    @Override
    public Map<String,Object> selectStoreAndPlan(String openId, String date) {
        return temporaryInfoMapper.selectStoreAndPlan(openId,date);
    }

    @Override
    public int batchInsertOrUpdate(List<WxTemporaryInfoDto> list) {
        // 空列表防护：避免无效SQL执行
        int affectRows;
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }

        try {
            // 1. 批量转换DTO → DO
            List<TemporaryInfoDO> doList = new ArrayList<>(list.size());
            for (WxTemporaryInfoDto dto : list) {
                TemporaryInfoDO entity = new TemporaryInfoDO();
                BeanUtils.copyProperties(dto, entity);
                doList.add(entity);
            }

            // 2. 调用Mapper层的批量插入/更新方法
            affectRows = temporaryInfoMapper.batchInsertOrUpdate(doList);

            // 3. 异常捕获：处理唯一键冲突（复用项目已有异常逻辑）
        } catch (Exception e) {
            affectRows = 0;
            String eMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            if (eMsg.contains("for key 'open_id_unique'")) {
                throw new ParamException(RCode.USER_WXOPENID_UNIQUE_ERROR);
            } else if (eMsg.contains("for key 'phone_unique'")) {
                throw new ParamException(RCode.USER_PHONE_UNIQUE_ERROR);
            }
        }

        return affectRows;
    }

    private LambdaQueryWrapper<TemporaryInfoDO> buildQueryList(TemporaryWrapper tw) {
        LambdaQueryWrapper<TemporaryInfoDO> queryWrapper = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(tw.getOpenId())) {
            queryWrapper.eq(TemporaryInfoDO::getOpenId, tw.getOpenId());
        }
        if (StringUtils.isNotBlank(tw.getPhone())) {
            queryWrapper.eq(TemporaryInfoDO::getPhone, tw.getPhone());
        }
        if (StringUtils.isNotBlank(tw.getChargerQcId())) {
            queryWrapper.eq(TemporaryInfoDO::getChargerQcId, tw.getChargerQcId());
        }
        if (StringUtils.isNotBlank(tw.getNameLike())) {
            queryWrapper.like(TemporaryInfoDO::getName, tw.getNameLike());
        }
        if (StringUtils.isNotBlank(tw.getDeptQcId())) {
            queryWrapper.eq(TemporaryInfoDO::getDeptQcId, tw.getDeptQcId());
        }
        return queryWrapper;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<WxTemporaryInfoDto> transitionDtos(List<TemporaryInfoDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<WxTemporaryInfoDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryInfoDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDo DO对象
     * @return DTO对象
     */
    private WxTemporaryInfoDto transitionDto(TemporaryInfoDO temDo) {
        WxTemporaryInfoDto temporaryDto = null;
        if (!Objects.isNull(temDo)) {
            temporaryDto = new WxTemporaryInfoDto();
            BeanUtils.copyProperties(temDo, temporaryDto);
        }
        return temporaryDto;
    }
}
