package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeQueryTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-30 11
 * @describe : 员工查询促销员活动上报信息
 */
@Service
@Slf4j
public class EmployeeQueryTemActivityServiceImpl implements EmployeeQueryTemActivityService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Override
    public void getEmployeeApproveActivityPage(String employeeQcId, PageInfo pageInfo) {
        TemporaryActivityWrapper tw = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryActivityWrapper.class);
        tw = Objects.isNull(tw) ? new TemporaryActivityWrapper() : tw;
        tw.setApproverId(employeeQcId)
                .setNotApproveStatus(TemActApproveStatus.SUBMITTED.name());
        temporaryActivityReportedDao.findListToEmployeePage(tw, pageInfo);
    }
}
