package com.wangxiaolu.promotion.controller.wechat;

import com.wangxiaolu.promotion.common.util.DataUtils;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryLoginVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 13
 * @describe :微信用户信息查询
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/query")
public class WeChatUserQueryController {

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;

    /**
     * 根据OpenId、Phone登录（促销员查询是否存在）
     *
     * @return 非null则登录成功
     */
    @PostMapping("/temporary/login/phone_openid")
    public R temporaryLoginByPhoneAndOpenId(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        phontAndOpenIdVerify(wxTemporaryLoginVo);
        if (!DataUtils.phonePattern(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        String s = weChatUserQueryService.loginTemporaryByOpenIdAndPhone(wxTemporaryLoginVo.getOpenId(), wxTemporaryLoginVo.getPhone());
        return R.success(s);
    }


    /**
     * 促销员信息查询
     */
    @PostMapping("/temporary/phone_openid")
    public R getTemporaryInfoByOpenIdAndPhone(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        phontAndOpenIdVerify(wxTemporaryLoginVo);
        WxTemporaryInfoDto temporaryInfoDto = weChatUserQueryService.getTemporaryInfoByOpenIdAndPhone(wxTemporaryLoginVo.getOpenId(), wxTemporaryLoginVo.getPhone());
        if (Objects.isNull(temporaryInfoDto)) {
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, null);
        }
        return R.success(temporaryInfoDto);
    }

    private void phontAndOpenIdVerify(WxTemporaryLoginVo wxTemporaryLoginVo) {
        if (StringUtils.isBlank(wxTemporaryLoginVo.getOpenId()) || StringUtils.isBlank(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, null);
        }
    }
}
