package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.uuid.Generators;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.activity.dao.*;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityMarketCellDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityMarketCellVo;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import com.wangxiaolu.promotion.utils.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityCoreServiceImpl implements TemporaryActivityCoreService {
    @Autowired
    QinCeUtils qinCeUtils;
    @Autowired
    RedisCache redisCache;
    @Autowired
    private TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    private PromotionStoreDao promotionStoreDao;
    @Autowired
    private TemporaryActivityPhotoDao tempActivityPhotoDao;
    @Autowired
    private TemporaryActivityLogDao tempActivityLogDao;
    @Autowired
    private TemporaryInfoDao temporaryInfoDao;
    @Autowired
    private TemporaryActivityMarketCellDao temporaryActivityMarketCellDao;
    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;
    @Autowired
    private TemporaryActivityClockQueryService clockQueryService;


    /**
     * 活动上报保存
     *
     * @return 生成id
     */
    @Override
    public long activityDataReportedSave(TemporaryActivityReportedDto temActDto) {
        // 判断是否已存在保存数据
        TemporaryActivityReportedDto haveDate = temporaryActivityReportedDao.findOneByCurrentDate(temActDto.getTemporaryId());
        if (Objects.nonNull(haveDate)) {
            throw new FlowException(RCode.DATA_HAVE_ERROR);
        }

        // 获取计划信息，补充此计划的销售品项和执行方式
        ActivityPlanInfoDto planInfoDto = activityPlanInfoDao.selectById(temActDto.getPlanId());
        temActDto.setPrdClass(Objects.isNull(planInfoDto) ? null : planInfoDto.getPrdClass());
        temActDto.setExecuteModePlan(Objects.isNull(planInfoDto) ? null : planInfoDto.getPlanExecuteMode());
        // 返回生成的活动id
        long reportedId = temporaryActivityReportedDao.activityDataSave(temActDto);
        temActDto.setId(reportedId);

        // 保存图片
        saveActivityPhotoV2(temActDto);


        // 售卖单元新增保存
//        String key = temMarketCellRedisKey(temActDto.getTemporaryId());
//        temporaryActivityMarketCellDao.saveList(reportedId,redisCache.getToJsonArray(key));
//        redisCache.removeKey(key);

//        tempActivityLogDao.save(temActDto.getTemporaryId(), temActDto.getTemporaryName(), LogType.t_2, temActDto.getId(), temActDto);
        return reportedId;
    }

    /**
     * 活动信息修改
     * 1、判断活动是否可以修改
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void activityDataReportedUpdate(TemporaryActivityReportedDto temActDto) {
        // 图片增量保存
        saveActivityPhotoV2(temActDto);
        // 如果数量小于2  修改状态为 SUBMITTED 已保存
        if(ObjectUtil.isAllNotEmpty(temActDto.getTgscPhotoUrls(),temActDto.getTghdPhotoUrls(),temActDto.getTgcjPhotoUrls())){
            temActDto.setApproveStatus(TemActApproveStatus.APPROVED);
        }
        WxTemporaryInfoDto wxTemporaryInfoDto = temporaryInfoDao.selectOneById(temActDto.getTemporaryId());
        temActDto.setTemporaryPhone(wxTemporaryInfoDto.getPhone());
        temporaryActivityReportedDao.updateById(temActDto);

        // 售卖单元新增保存
//        String key = temMarketCellRedisKey(temActDto.getTemporaryId());
//        temporaryActivityMarketCellDao.saveList(temActDto.getId(),redisCache.getToJsonArray(key));
//        redisCache.removeKey(key);
        // 日志保存
//        tempActivityLogDao.save(temActDto.getTemporaryId(), temActDto.getTemporaryName(), LogType.t_2, temActDto.getId(), temActDto);
    }

    /**
     * 修改审批状态
     *
     * @param id 上报记录id
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void activityReportedSubmit(Long id) {
        // 判断此id任务是否存在，并且是否满足提交审批条件
        TemporaryActivityReportedDto reportedDto = temporaryActivityReportedDao.findOneById(id);
        if (Objects.isNull(reportedDto)) {
            throw new ParamException(RCode.DATA_NOT_HAVE_ERROR, null);
        }

        // 查询促销员负责人，将人员补充到审批中
        TemporaryActivityReportedDto updateDto = new TemporaryActivityReportedDto()
                .setId(id)
                .setApproveStatus(TemActApproveStatus.APPROVED)
                .setApproveTime(new Date());

        // 修改审批
        temporaryActivityReportedDao.updateById(updateDto);

        // 日志保存
//        tempActivityLogDao.save(reportedDto.getTemporaryId(), reportedDto.getTemporaryName(), LogType.t_3, updateDto.getId(), updateDto);
    }

    @Override
    public void todayActivityMarketCellReported(TemporaryActivityMarketCellVo marketcellVo) {
        String key = temMarketCellRedisKey(marketcellVo.getTemporaryId());
        JSONArray marketCells = redisCache.getToJsonArray(key);
        if (Objects.isNull(marketCells)) {
            marketCells = new JSONArray();
        } else {
            // 判断prdId是否已存在
            List<String> prdIdList = marketCells.stream().map(o -> ((JSONObject) o).getString("prdId")).collect(Collectors.toList());
            if (prdIdList.contains(marketcellVo.getPrdId())) {
                throw new ParamException(RCode.PRODUCT_CLASS_HAS_ERROR, null);
            }
        }

        marketcellVo.setUuid(Generators.randomBasedGenerator().generate().toString());
        marketCells.add(marketcellVo);
        redisCache.addToJsonToMinute(key, marketCells, 30);
    }

    @Override
    public void todayActivityDeleteMarketCellReported(Long temporaryId) {
        String key = temMarketCellRedisKey(temporaryId);
        redisCache.removeKey(key);
    }

    @Override
    public void todayUpdateMarketCellOne(TemporaryActivityMarketCellVo marketcellVo) {
        // 修改/删除 缓存中的数据
        if (StringUtils.isNotBlank(marketcellVo.getUuid())) {
            todayUpdateMarketCellOneToRedis(marketcellVo);
        }

        //  修改/删除 DB库中的数据
        if (Objects.nonNull(marketcellVo.getMarketCellId())) {
            todayUpdateMarketCellOneToDb(marketcellVo);
        }
    }

    private void todayUpdateMarketCellOneToDb(TemporaryActivityMarketCellVo marketcellVo) {
        if (marketcellVo.operateIsDelete()) {
            temporaryActivityMarketCellDao.deleteById(marketcellVo.getMarketCellId());
        }

        if (marketcellVo.operateIsUpdate()) {
            TemporaryActivityMarketCellDto dto = new TemporaryActivityMarketCellDto()
                    .setId(marketcellVo.getMarketCellId())
                    .setBag(marketcellVo.getBag())
                    .setBox(marketcellVo.getBox());
            temporaryActivityMarketCellDao.updateById(dto);
        }

    }

    private void todayUpdateMarketCellOneToRedis(TemporaryActivityMarketCellVo marketcellVo) {
        String key = temMarketCellRedisKey(marketcellVo.getTemporaryId());
        JSONArray marketCells = redisCache.getToJsonArray(key);
        if (Objects.isNull(marketCells)) {
            throw new ParamException(RCode.DATA_NOT_HAVE_ERROR, null);
        }

        String uuid = marketcellVo.getUuid();

        if (marketcellVo.operateIsUpdate()) {
            marketCells.stream().forEach(jo -> {
                JSONObject mj = (JSONObject) jo;
                String uuidR = mj.getString("uuid");
                if (uuidR.equals(uuid)) {
                    mj.put("box", marketcellVo.getBox());
                    mj.put("bag", marketcellVo.getBag());
                }
            });
        }

        if (marketcellVo.operateIsDelete()) {
            for (int i = 0; i < marketCells.size(); i++) {
                JSONObject mj = (JSONObject) marketCells.get(i);
                String uuidR = mj.getString("uuid");
                if (uuidR.equals(uuid)) {
                    marketCells.remove(i);
                    break;
                }
            }
        }

        redisCache.removeKey(key);
        if (!CollectionUtils.isEmpty(marketCells)) {
            redisCache.addToJsonToMinute(key, marketCells, 30);
        }
    }

    private String temMarketCellRedisKey(Long temporaryId) {
        return RedisKeys.TemporaryKeys.TEMPORARY_ACTIVITY_MARKET_CELL.getKey() + temporaryId + "_" + DateUtil.today();
    }

    /**
     * 推广活动照片保存
     *
     * @param temActDto 活动提交数据
     */
    private void saveActivityPhotoV2(TemporaryActivityReportedDto temActDto) {
        Long temporaryId = temActDto.getTemporaryId();
        Long reportedId = temActDto.getId();
        // 推广试吃照片
        if (CollectionUtils.isEmpty(temActDto.getTgscPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.TGSC.getType());
        } else {
            tempActivityPhotoDao.saveReportedList(null, temporaryId, reportedId, ActivityPhotoType.TGSC.getType(), temActDto.getTgscPhotoUrls());
        }

        // 推广互动照片
        if (CollectionUtils.isEmpty(temActDto.getTghdPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.TGHD.getType());
        } else {
            // 查询打卡数据 根据上报id 查询
//            TemporaryClockWrapper wr = new TemporaryClockWrapper();
//            wr.setReportedId(reportedId);
//            wr.setTemporaryId(temporaryId);
//            TemporaryClockDto clockDto = clockQueryService.findClockInfo(wr);
            tempActivityPhotoDao.saveReportedList(null, temporaryId, reportedId, ActivityPhotoType.TGHD.getType(), temActDto.getTghdPhotoUrls());
        }

        // 推广成交照片
        if (CollectionUtils.isEmpty(temActDto.getTgcjPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.TGCJ.getType());
        } else {
            // 查询打卡数据 根据上报id 查询
//            TemporaryClockWrapper wr = new TemporaryClockWrapper();
//            wr.setReportedId(reportedId);
//            wr.setTemporaryId(temporaryId);
//            TemporaryClockDto clockDto = clockQueryService.findClockInfo(wr);

            tempActivityPhotoDao.saveReportedList(null, temporaryId, reportedId, ActivityPhotoType.TGCJ.getType(), temActDto.getTgcjPhotoUrls());
        }
        // 试吃品
        if (CollectionUtils.isEmpty(temActDto.getScpPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.TASTY_PHOTO.getType());
        }else {
            tempActivityPhotoDao.saveReportedList(null,temporaryId, reportedId, ActivityPhotoType.TASTY_PHOTO.getType(), temActDto.getScpPhotoUrls());
        }
        // 配发赠品照片
        if (CollectionUtils.isEmpty(temActDto.getPfzpPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.SEND_GIFT_PHOTO.getType());
        } else {
            tempActivityPhotoDao.saveReportedList(null,temporaryId, reportedId, ActivityPhotoType.SEND_GIFT_PHOTO.getType(), temActDto.getPfzpPhotoUrls());
        }
         //POS机页面凭证
        if (CollectionUtils.isEmpty(temActDto.getPsvPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.POS_SELL_VOUCHER.getType());
        } else {
            tempActivityPhotoDao.saveReportedList(null,temporaryId, reportedId, ActivityPhotoType.POS_SELL_VOUCHER.getType(), temActDto.getPsvPhotoUrls());
        }
        //高峰期在岗
        if (CollectionUtils.isEmpty(temActDto.getGfqPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.RANDOM_TASK.getType());
        } else {
            tempActivityPhotoDao.saveReportedList(null,temporaryId, reportedId, ActivityPhotoType.RANDOM_TASK.getType(), temActDto.getGfqPhotoUrls());
        }

        // 试吃必备物料照片
        if (CollectionUtils.isEmpty(temActDto.getScbbwlPhotoUrls())) {
            tempActivityPhotoDao.deleteList(reportedId, ActivityPhotoType.TASTY_MATERIALS.getType());
        } else {
            tempActivityPhotoDao.saveReportedList(null,temporaryId, reportedId, ActivityPhotoType.TASTY_MATERIALS.getType(), temActDto.getScbbwlPhotoUrls());
        }

    }

//    private void saveActivityPhoto(TemporaryActivityReportedDto temActDto) {
//         Long temporaryId = temActDto.getTemporaryId();
//        Long reportedId = temActDto.getId();
//        // 推广试吃照片
//        if (!CollectionUtils.isEmpty(temActDto.getTgscPhotoUrls())) {
//            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.TGSC.getType(), temActDto.getTgscPhotoUrls(), temActDto.getTgscChangePhotoUrls());
//        }
//
//        // 推广互动照片
//        if (!CollectionUtils.isEmpty(temActDto.getTghdPhotoUrls())) {
//            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.TGHD.getType(), temActDto.getTghdPhotoUrls(), temActDto.getTghdChangePhotoUrls());
//        }
//
//        // 推广成交照片
//        if (!CollectionUtils.isEmpty(temActDto.getTgcjPhotoUrls())) {
//            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.TGCJ.getType(), temActDto.getTgcjPhotoUrls(), temActDto.getTgcjChangePhotoUrls());
//        }
//        // POS机页面凭证
//        if (!CollectionUtils.isEmpty(temActDto.getPsvPhotoUrls())) {
//            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.POS_SELL_VOUCHER.getType(), temActDto.getPsvPhotoUrls(), temActDto.getPsvChangePhotoUrls());
//        }
//    }
}
