package com.wangxiaolu.promotion.config.thread;

import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

/**
 * @author : liqiulin
 * @date : 2024-03-29 10
 * @describe : 线程配置
 */
@EnableAsync
@Configuration
public class AsyncThreadConfig implements AsyncConfigurer {
    @Value("${async.executor.thread.core_pool_size}")
    private int corePoolSize;
    @Value("${async.executor.thread.name.prefix}")
    private String namePrefix;

    @Override
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //核心数量，根据cpu确认
        //核心线程池数量
        executor.setCorePoolSize(corePoolSize);
        //最大线程数量
        executor.setMaxPoolSize(corePoolSize*5);
        //线程池的队列容量
        executor.setQueueCapacity(corePoolSize*2);
        //线程名称的前缀
        executor.setThreadNamePrefix(namePrefix);
        executor.initialize();
        return executor;
    }

    @Override
    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }
}
