package com.wangxiaolu.promotion.config;

import com.wangxiaolu.promotion.websocket.JwtHandshakeInterceptor;
import com.wangxiaolu.promotion.websocket.TemporaryActivityTaskClockSocketHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

/**
 * WebSocket配置类
 * @author : lvbencai
 * @date : 2024/4/16
 */
@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry
                // 注册WebSocket处理器和路径
                .addHandler(webSocketHandler(), "/ws/temporary/plan")
                // 允许跨域（根据实际前端域名配置）setAllowedOriginPatterns
                .setAllowedOrigins("*")
                // 添加握手拦截器（用于JWT验证）
                .addInterceptors(handshakeInterceptor());
    }

    @Bean
    public WebSocketHandler webSocketHandler() {
        return new TemporaryActivityTaskClockSocketHandler();
    }

    @Bean
    public HandshakeInterceptor handshakeInterceptor() {
        return new JwtHandshakeInterceptor();
    }
}
