package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.PromotionStoreDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.PromotionStoreWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.PromotionStoreVo;
import com.wangxiaolu.promotion.service.activity.temporary.PromotionStoreQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-18 15
 * @describe :
 */
@Service
public class PromotionStoreQueryServiceImpl implements PromotionStoreQueryService {

    @Autowired
    PromotionStoreDao promotionStoreDao;


    @Override
    public List<PromotionStoreDto> findStoreList(PromotionStoreVo promotionStoreVo) {
        PromotionStoreWrapper promotionStoreWrapper = new PromotionStoreWrapper();
        promotionStoreWrapper.setStoreNameLike(promotionStoreVo.getStoreNameLike());

        if ("全国".equals(promotionStoreVo.getArea())){
            promotionStoreWrapper.setProvince("");
            promotionStoreWrapper.setCity("");
            promotionStoreWrapper.setArea("");
        }else {
            promotionStoreWrapper.setProvince(promotionStoreVo.getProvince());
            promotionStoreWrapper.setCity(promotionStoreVo.getCity());
            promotionStoreWrapper.setArea(promotionStoreVo.getArea());
        }

        return promotionStoreDao.findList(promotionStoreWrapper);
    }
}
