package com.wangxiaolu.promotion.controller.activity.temporary;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityDataVo;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityMarketCellVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.*;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员活动上报、修改
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/core")
public class TemporaryActivityCoreController {
    @Autowired
    private TemporaryActivityCoreService tempActivityCoreService;
    @Autowired
    private TemporaryActivityClockQueryService tempActivityClockQueryService;
    @Autowired
    private TemporaryActivityQueryService temporaryActivityQueryService;
    @Autowired
    private TemporaryActivityClockCoreService tempActivityClockCoreService;

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;

    /**
     * 促销员[今日活动]数据保存
     * 返回活动生成id
     */
    @Transactional(rollbackFor = Exception.class)
    @PostMapping("/today/reported")
    public R todayActivityDataReported(@RequestBody TemporaryActivityDataVo activityVo) {
        if (Objects.isNull(activityVo.getTemporaryId())){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR);
        }
        TemporaryActivityReportedDto temActDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(activityVo, temActDto);
        temActDto.setId(activityVo.getActivityReportedId());

        //保存促销员电话号码
        String temporaryPhone = weChatUserQueryService.findUserPhoneByID(activityVo.getTemporaryId());
        temActDto.setTemporaryPhone(temporaryPhone);

        /**
         * 已有id，修改任务
         */
        if (Objects.nonNull(activityVo.getActivityReportedId())) {
            tempActivityCoreService.activityDataReportedUpdate(temActDto);
            return R.success(activityVo.getActivityReportedId());
        }

        /**
         * 新增任务
         */
        TemporaryClockDto clockDto = tempActivityClockQueryService.findTodayTemporaryClockByTemId(temActDto.getTemporaryId());
        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED)
                .setDealerName(clockDto.getDealerName())
                .setLineName(clockDto.getLineName())
                .setPlanId(clockDto.getPlanId())
                .setStoreName(clockDto.getStoreName())
                .setDeptQcId(clockDto.getDeptQcId())
                .setDeptQcOrgName(clockDto.getDeptQcOrgName())
                .setManageId(clockDto.getChargerId())
                .setManageName(clockDto.getChargerName())
                .setActivityPatternId(clockDto.getActivityPatternId())
                .setActivityPattern(clockDto.getActivityPattern())
                .setProvince(clockDto.getClockProvince())
                .setCity(clockDto.getClockCity()).setTemporaryPhone(clockDto.getPhone())
        ;

        long reportedId = tempActivityCoreService.activityDataReportedSave(temActDto);

        TemporaryClockDto clockDtoUpdate = new TemporaryClockDto();
        clockDtoUpdate.setId(clockDto.getId()).setReportedId(reportedId);
        tempActivityClockCoreService.updateById(clockDtoUpdate);
        return R.success(reportedId);
    }

    /**
     * 促销员[今日活动 - （出售列表中添加）出售单元]数据
     * 数据暂存到redis中，当调用保存接口时再添加到数据库中
     * 返回保存成功信息
     */
    @PostMapping("/today/reported/market_cell")
    public R todayActivityMarketCellReported(@RequestBody TemporaryActivityMarketCellVo marketcellVo) {
        marketcellVo.saveDataVerify();
        tempActivityCoreService.todayActivityMarketCellReported(marketcellVo);
        return R.success();
    }

    /**
     * 修改/删除促销员[今日活动 - （出售列表中添加）出售单元]某一条数据
     */
    @PutMapping("/today/reported/market_cell/one")
    public R todayUpdateMarketCellOne(@RequestBody TemporaryActivityMarketCellVo marketcellVo) {
        marketcellVo.updateDataVerify();
        tempActivityCoreService.todayUpdateMarketCellOne(marketcellVo);
        return R.success();
    }

    /**
     * 删除促销员[今日活动 - （出售列表中添加）出售单元]在缓存中的全部数据
     * 当促销员取消保存活动记录时，数据进行删除
     */
    @DeleteMapping("/today/reported/market_cell/del")
    public R todayDeleteMarketCellReported( Long temporaryId) {
        tempActivityCoreService.todayActivityDeleteMarketCellReported(temporaryId);
        return R.success();
    }

    /**
     * 促销员[今日活动]数据提交审批
     * 修改审批状态
     * 增加任务校验2025年11月17日16:01:47
     */
    @PutMapping("/reported/approve/submit/{id}")
    public R activityReportedSubmit(@PathVariable("id") Long id) {
        TemporaryActivityReportedDto activityReportedDto = temporaryActivityQueryService.findTemporaryActivityById(id);
        TemporaryClockDto clockInfo = tempActivityClockQueryService.findCLockInfoByReportedId(activityReportedDto.getId(),activityReportedDto.getTemporaryId());
            if (CollectionUtils.isEmpty(activityReportedDto.getTgscPhotoInfos()) ){
                throw new DataException(RCode.NOT_TGSH_PHOTO_ERROR);
            }else if (CollectionUtils.isEmpty(activityReportedDto.getTghdPhotoInfos()) ){
                throw new DataException(RCode.NOT_TGHD_PHOTO_ERROR);
            }else if (CollectionUtils.isEmpty(activityReportedDto.getTgcjPhotoInfos()) ){
                throw new DataException(RCode.NOT_TGCJ_PHOTO_ERROR);
            }else if (CollectionUtils.isEmpty(activityReportedDto.getScpPhotoInfos()) ){
                throw new DataException(RCode.NOT_SCP_PHOTO_ERROR);
            } else if (CollectionUtils.isEmpty(activityReportedDto.getPfzpPhotoInfos()) ){
                throw new DataException(RCode.NOT_PFZP_PHOTO_ERROR);
            } else if (CollectionUtils.isEmpty(activityReportedDto.getGfqPhotoInfos()) ){
                throw new DataException(RCode.NOT_GFQ_PHOTO_ERROR);
            } else if (CollectionUtils.isEmpty(activityReportedDto.getScbbwlPhotoInfos()) ){
                throw new DataException(RCode.NOT_SCBBWL_PHOTO_ERROR);
            }else if  ("是".equals(activityReportedDto.getHasBlackDuckFlavor()) &&StringUtils.isBlank(activityReportedDto.getHasBlackDuckFlavor())){
                throw new DataException(RCode.NOT_BLACK_DUCK_FLAVOR_ERROR);
            }else if ("是".equals(activityReportedDto.getHasBlackDuckFlavor()) &&activityReportedDto.getBlackDuckTastingNum() == null || activityReportedDto.getBlackDuckTastingNum() == 0 ){
                throw new DataException(RCode.NOT_BLACK_DUCK_TASTING_NUM_ERROR);
            }else if (activityReportedDto.getBraisedTastingNum() == null ){
                throw new DataException(RCode.NOT_BRAISED_TASTING_NUM_ERROR);
            }else if (activityReportedDto.getGiftNum() == null ){
                throw new DataException(RCode.NOT_GIFT_NUM_ERROR);
            }else if (activityReportedDto.getPromotionSales() == null ||(1== BigDecimal.ZERO.compareTo(activityReportedDto.getPromotionSales()))){
                throw new DataException(RCode.NOT_PROMOTION_SALES_ERROR);
            }else if ("是".equals(activityReportedDto.getHasBlackDuckFlavor()) && activityReportedDto.getBlackDuckSales() == null ){
                throw new DataException(RCode.NOT_BLACK_DUCK_SALES_ERROR);
            }else if (activityReportedDto.getGiftBoxSales() == null ){
                throw new DataException(RCode.NOT_GIFT_SALES_ERROR);
            }else if (activityReportedDto.getPsvPhotoInfos() == null ){
                throw new DataException(RCode.NOT_POS_PHOTO_ERROR);
            }
        Date clockInTime = clockInfo.getClockInTime();
        Date noonClockInTime = clockInfo.getNoonClockInTime();
        Date noonClockOutTime = clockInfo.getNoonClockOutTime();
        Date clockOutTime = new Date();

        long totalMinutes = 0;
        boolean isNoonCardMissing = Objects.isNull(clockInTime) || Objects.isNull(noonClockInTime);
        if (isNoonCardMissing) {
            // 午休缺卡：直接计算上班→下班的总时长
            totalMinutes = DateUtil.between(clockInTime, clockOutTime, DateUnit.MINUTE);

        } else {
            // 午休不缺卡：两段时长相加（上午段 + 下午段）
            // 上班→午休下班
            long morningMinutes = DateUtil.between(clockInTime, noonClockOutTime, DateUnit.MINUTE);
            long afternoonMinutes= DateUtil.between(noonClockInTime, clockOutTime, DateUnit.MINUTE);

            totalMinutes = morningMinutes + afternoonMinutes;
        }

        // 分钟转小时（保留1位小数，避免多位小数）
        double hours = Math.round((totalMinutes / 60.0) * 10) / 10.0;
        if (hours < 8.0){
            throw new DataException(RCode.NOT_ENOUGH_WORK_TIME_ERROR);
        }
        tempActivityCoreService.activityReportedSubmit(id);
        return R.success();
    }

}
