package com.wangxiaolu.promotion.pojo;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.wangxiaolu.promotion.exception.APIException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-04-19 13
 * @describe : 分页配置，默认每页10条记录
 */
@Data
public class PageInfo<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 当前页数，第1页开始
     */
    private int pageNum = 1;

    /**
     * 每页条数
     */
    private int pageSize = 1;

    /**
     * 总条数
     */
    private int totalRecord;

    /**
     * 总页数
     */
    private int totalPage;

    private List<T> records;

    private Map<String,Object> queryParams;

    /**
     *
     * current：当前页数，必须大于等于 1，默认值为 1。
     * size：每页条数，默认值为 10。
     * total：总条数，默认值为 0。
     * records：当前页数据集合，默认值为空集合。
     * searchCount：是否进行 count 查询，默认值为 true，表示会统计总条数。
     * pages：总页数，通过计算得出。
     * optimizeCountSql：是否优化 count 查询，默认值为 true。
     * hitCount：是否对 count 进行 limit 优化，默认值为 false。
     * countId：count 查询的列名，默认为 null，表示所有列。
     * maxLimit：设置最大的 limit 查询限制，默认值为 -1，表示不限制。
     * @param iPage 查询出的分页对象
     * @param t 需要转换的对象（用于返回前端，不能直接返回DO）
     * @param <P> 分页对象中的类型
     */
    public <P> void pageCovert(IPage<P> iPage, Class<T> t) {
        this.totalRecord = (int) iPage.getTotal();
        this.totalPage = (int) iPage.getPages();

        List<P> iPageRecords = iPage.getRecords();
        if (CollectionUtils.isEmpty(iPageRecords)) {
            this.records = new ArrayList<>();
            return;
        }

        try {
            List<T> tList = new ArrayList<>(iPageRecords.size() * 2);
            for (P pr : iPageRecords) {
                T newT = t.newInstance();
                // 把原对象数据拷贝到新的对象
                BeanUtil.copyProperties(pr, newT);
                tList.add(newT);
            }
            this.records = tList;
        } catch (Exception e) {
            throw new APIException(RCode.FAILED, e.getMessage());
        }
    }

    public <P> void pageCovert(IPage<P> iPage) {
        this.totalRecord = (int) iPage.getTotal();
        this.totalPage = (int) iPage.getPages();
    }

    public int getSkipNum(){
        return this.pageSize * (this.pageNum - 1);
    }
}
