package com.wangxiaolu.promotion.domain.activityplanv2.dao;

import com.alibaba.fastjson.JSONArray;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfoDo;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.TemporaryRegisterVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-02-06 11
 * @describe :
 */
public interface ActivityPlanInfoDao {
    void saveList(JSONArray table, Long recordId);

    void page(PageInfo pageInfo, ActivityPlanInfoWrapper wrapper);

    ActivityPlanInfoDto selectPlan(String storeCode, Date date);

    void deleteByPlanIds(List<Long> planIds, String employeeNo,String operNo);

    void updateList(JSONArray table, Long recordId);

    ActivityPlanInfoDto selectById(Long id);

    void updateById(ActivityPlanInfoDto planDto);

    void save(ActivityPlanInfoDto planDto);

    List<ActivityPlanInfoDto> findClockList(ActivityPlanInfoWrapper wrapper);

    void updatePlanStatus(Long planId, PlanStatus planStatus);

    void updateByIds(List<Long> planIds, ActivityPlanInfoDto planDto);

    /**
     * 根据位置信息查询当前月份的促销门店
     * @param planDay 查询条件参数
     * @return 门店信息列表
     */
    List<Map<String, String>> findThisMonthStoreListByLocation(String planDay,String storeNameKeyword);

}
