package com.wangxiaolu.promotion.controller.user.qince;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.CascadeVo;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductInfoDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductTypeDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.QinCeProductQueryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-19 17
 * @describe : 商品信息查询
 */
@RestController
@RequestMapping("/user/qince/query")
public class QinCeProductQueryController {

    @Autowired
    QinCeProductQueryService qinCeProductQueryService;

    @PostMapping("/product/type/list")
    public R findProductTypeList() {
        List<QinceProductTypeDto> dtos = qinCeProductQueryService.findProductTypeList();
        return R.success(dtos);
    }

    /**
     * 级联选择
     *
     * @return
     */
    @PostMapping("/product/cascade")
    public R findProductCascade() {
        List<CascadeVo> dtos = qinCeProductQueryService.findProductCascade();
        return R.success(dtos);
    }

    /**
     * 根据69码选择商品
     */
    @GetMapping("/product/info")
    public R findProductInfo(QinceProductInfoDto params) {
        if (StringUtils.isBlank(params.getPrdSpec())) {
            throw new ParamException(RCode.BAR_CODE_IS_ERROR, null);
        }
        QinceProductInfoDto productInfo = qinCeProductQueryService.findProductInfo(params);

        if (Objects.isNull(productInfo)) {
            throw new ParamException(RCode.BAR_CODE_IS_ERROR, null);
        }

        return R.success(productInfo);
    }

}
