package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityLogDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.ClockType;
import com.wangxiaolu.promotion.enums.activity.LogType;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockCoreService;
import com.wangxiaolu.promotion.utils.OkHttp;
import com.wangxiaolu.promotion.utils.QinCeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-07-02 10
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityClockCoreServiceImpl implements TemporaryActivityClockCoreService {

    @Autowired
    QinCeUtils qinCeUtils;
    @Autowired
    private TemporaryActivityClockDao temporaryActivityClockDao;
    @Autowired
    private TemporaryActivityPhotoDao tempActivityPhotoDao;
    @Autowired
    private EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;
    @Autowired
    private ManageEmployeeInfoDao manageEmployeeInfoDao;
    @Autowired
    private TemporaryActivityLogDao tempActivityLogDao;
    /**
     * 促销员当日打卡信息保存
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void clockInTodayActivity(TemporaryClockDto dto, Integer clockType) {
        log.info("促销员当日打卡[type-{}]信息保存：{}", clockType, dto.toString());
        if (Objects.isNull(dto.getId())) {
            // 补充信息
            EmployeeActivityPlanInfoDto planInfoDto = employeeActivityPlanInfoDao.selectById(dto.getStoreId());
            ManageEmployeeInfoDto employeeDto = manageEmployeeInfoDao.selectById(planInfoDto.getEmployeeId());

            dto.setLineName(planInfoDto.getLineName())
                    .setDeptQcId(employeeDto.getDeptQcId())
                    .setDeptQcOrgName(employeeDto.getDeptQcName())
                    .setChargerQcId(employeeDto.getQcId())
                    .setChargerName(employeeDto.getName())
                    .setActivityPatternId(planInfoDto.getActivityPatternId())
                    .setActivityPattern(planInfoDto.getActivityPattern());
            temporaryActivityClockDao.save(dto);
        } else {
            temporaryActivityClockDao.updateById(dto);
        }
        // 根据ID保存图片
        saveClockPhoto(dto, clockType);
        // 日志保存
        tempActivityLogDao.save(dto.getTemporaryId(), dto.getTemporaryName(), LogType.t_1, dto.getId(), dto);
    }

    /**
     * 根据店铺或打卡记录中的店铺，判断打卡距离
     * 经度，范围为 -180~180，负数表示西经;纬度，范围为 -90~90，负数表示南纬
     *
     * @param storeQcId        店铺-勤策-id
     * @param id               打卡记录id
     * @param clockCoordinates 打卡经纬度
     */
    @Override
    public void clockStoreCalDistance(String storeQcId, Long id, String clockCoordinates) {
//        if (Objects.nonNull(id)) {
//            TemporaryClockDto clockDto = temporaryActivityClockDao.selectOne(new TemporaryClockWrapper().setId(id));
//            storeQcId = clockDto.getStoreQcId();
//        }
//        clockStoreCalDistanceByStoreQcId(storeQcId, clockCoordinates);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateClockPhoto(TemporaryClockDto dto) {
        TemporaryPhotoWrapper pw = new TemporaryPhotoWrapper()
                .setType(dto.getBrevityClockType())
                .setClockId(dto.getId())
                .setTemporaryId(dto.getTemporaryId());
        // 根据id、type修改照片删除状态
        tempActivityPhotoDao.updateStatus(pw,0);

        // 将照片新增到表
        tempActivityPhotoDao.saveClockPhotoByUpdate(dto.getTemporaryId(),dto.getId(),dto.getBrevityClockType(),dto.getBrevityClockPhoto());
    }

    @Override
    public void updateById(TemporaryClockDto clockDto) {
        temporaryActivityClockDao.updateById(clockDto);
    }

    private void clockStoreCalDistanceByStoreQcId(String storeQcId, String clockCoordinates) {
        // 查询组织架构参数、创建url
        String[] clockCoordinateArr = clockCoordinates.split(",");
        List<Map> paramList = qinCeUtils.queryCalDistanceParam(storeQcId, clockCoordinateArr[0], clockCoordinateArr[1]);
        String url = qinCeUtils.builderUrlList(QinCeUtils.CAL_DISTANCE, paramList);

        // 发起请求、接收结果
        JSONObject resultJson = OkHttp.postQC(url, paramList);
        String rData = resultJson.getString("response_data");
        if (StringUtils.isBlank(rData) || !rData.contains(storeQcId)) {
            throw new ParamException(RCode.PRO_NOT_QC_STORE_CLOCK_DISTANCE, null);
        }
        Long distance = JSONObject.parseArray(rData).getJSONObject(0).getLong("distance");
        log.info("[打卡] 判断打卡距离，勤策-id:{}，打卡距离:{}，打卡经纬度:{}", storeQcId, distance, clockCoordinates);
//        判断打卡距离
        if (distance > 100L) {
            throw new ParamException(RCode.PRO_FAR_QC_STORE_CLOCK_DISTANCE, null);
        }
    }

    /**
     * 促销员上班打卡图片保存
     */
    private void saveClockPhoto(TemporaryClockDto dto, Integer clockType) {
        // 上班卡、午休下班卡、午休上班卡、下班卡
        if (ClockType.TEMPORARY_CLOCK_IN.equals(clockType)) {
            tempActivityPhotoDao.saveClockPhoto(dto.getTemporaryId(), dto.getId(), ActivityPhotoType.CLOCK_IN.getType(), dto.getClockInPhoto());
        } else if (ClockType.TEMPORARY_NOON_CLOCK_OUT.equals(clockType)) {
            tempActivityPhotoDao.saveClockPhoto(dto.getTemporaryId(), dto.getId(), ActivityPhotoType.NOON_CLOCK_OUT.getType(), dto.getNoonClockOutPhoto());
        } else if (ClockType.TEMPORARY_NOON_CLOCK_IN.equals(clockType)) {
            tempActivityPhotoDao.saveClockPhoto(dto.getTemporaryId(), dto.getId(), ActivityPhotoType.NOON_CLOCK_IN.getType(), dto.getNoonClockInPhoto());
        } else if (ClockType.TEMPORARY_CLOCK_OUT.equals(clockType)) {
            tempActivityPhotoDao.saveClockPhoto(dto.getTemporaryId(), dto.getId(), ActivityPhotoType.CLOCK_OUT.getType(), dto.getClockOutPhoto());
        }
    }
}
